/*
 * Decompiled with CFR 0.152.
 */
package gtime.schema.impl.runtime;

import com.sun.xml.bind.ProxyGroup;
import com.sun.xml.bind.serializer.AbortSerializationException;
import com.sun.xml.bind.validator.Messages;
import gtime.schema.impl.runtime.DefaultJAXBContextImpl;
import gtime.schema.impl.runtime.IdentityHashSet;
import gtime.schema.impl.runtime.MSVValidator;
import gtime.schema.impl.runtime.NamespaceContextImpl;
import gtime.schema.impl.runtime.ValidatableObject;
import gtime.schema.impl.runtime.XMLSerializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.helpers.NotIdentifiableEventImpl;
import javax.xml.bind.helpers.ValidationEventImpl;
import javax.xml.bind.helpers.ValidationEventLocatorImpl;
import org.xml.sax.SAXException;

class ValidationContext {
    final DefaultJAXBContextImpl jaxbContext;
    private final IdentityHashSet validatedObjects = new IdentityHashSet();
    private final NamespaceContextImpl nsContext = new NamespaceContextImpl(null);
    private final boolean validateID;
    private final HashSet IDs = new HashSet();
    private final HashMap IDREFs = new HashMap();
    private final ValidationEventHandler eventHandler;

    ValidationContext(DefaultJAXBContextImpl _context, ValidationEventHandler _eventHandler, boolean validateID) {
        this.jaxbContext = _context;
        this.eventHandler = _eventHandler;
        this.validateID = validateID;
    }

    public void validate(ValidatableObject vo) throws SAXException {
        if (this.validatedObjects.add(ProxyGroup.unwrap(vo))) {
            MSVValidator.validate(this.jaxbContext, this, vo);
        } else {
            this.reportEvent(vo, Messages.format("ValidationContext.CycleDetected"));
        }
    }

    public NamespaceContextImpl getNamespaceContext() {
        return this.nsContext;
    }

    public String onID(XMLSerializable owner, String value) throws SAXException {
        if (!this.validateID) {
            return value;
        }
        if (!this.IDs.add(value)) {
            this.reportEvent(this.jaxbContext.getGrammarInfo().castToValidatableObject(owner), Messages.format("ValidationContext.DuplicateId", value));
        }
        return value;
    }

    public String onIDREF(XMLSerializable referer, String value) throws SAXException {
        if (!this.validateID) {
            return value;
        }
        if (this.IDs.contains(value)) {
            return value;
        }
        this.IDREFs.put(value, referer);
        return value;
    }

    protected void reconcileIDs() throws SAXException {
        if (!this.validateID) {
            return;
        }
        for (Map.Entry e : this.IDREFs.entrySet()) {
            if (this.IDs.contains(e.getKey())) continue;
            ValidatableObject source = (ValidatableObject)e.getValue();
            this.reportEvent(source, new NotIdentifiableEventImpl(1, Messages.format("ValidationContext.IdNotFound", e.getKey()), new ValidationEventLocatorImpl(source)));
        }
        this.IDREFs.clear();
    }

    public void reportEvent(ValidatableObject source, String formattedMessage) throws AbortSerializationException {
        this.reportEvent(source, new ValidationEventImpl(1, formattedMessage, new ValidationEventLocatorImpl(source)));
    }

    public void reportEvent(ValidatableObject source, Exception nestedException) throws AbortSerializationException {
        this.reportEvent(source, new ValidationEventImpl(1, nestedException.toString(), new ValidationEventLocatorImpl(source), nestedException));
    }

    public void reportEvent(ValidatableObject source, ValidationEvent event) throws AbortSerializationException {
        boolean r;
        try {
            r = this.eventHandler.handleEvent(event);
        }
        catch (RuntimeException re) {
            r = false;
        }
        if (!r) {
            throw new AbortSerializationException(event.getMessage());
        }
    }
}

