/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.processor;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.xml.transform.Templates;
import org.apache.xalan.templates.Stylesheet;

public class CompiledStylesheetBundle {
    static void createBundle(Stylesheet root, Vector compiledTemplates) {
        String outdir = "." + File.separator;
        try {
            ZipEntry ze;
            String zipname = null;
            String systemID = root.getSystemId();
            if (systemID != null) {
                int namestart = systemID.lastIndexOf(47) + 1;
                int nameend = systemID.lastIndexOf(35, namestart);
                if (nameend < 0) {
                    nameend = systemID.length();
                }
                if (namestart < nameend) {
                    zipname = systemID.substring(namestart, nameend);
                }
            }
            if (zipname == null) {
                zipname = "UnidentifiedStylesheet";
            }
            FileOutputStream f = new FileOutputStream(String.valueOf(outdir) + zipname + ".xsb");
            ZipOutputStream zf = new ZipOutputStream(f);
            zf.setMethod(8);
            byte[] buffer = new byte[4096];
            int i = compiledTemplates.size() - 1;
            while (i >= 0) {
                Class<?> c = compiledTemplates.elementAt(i).getClass();
                String fullname = c.getName();
                int start = fullname.lastIndexOf(".");
                String packagename = fullname.substring(0, start);
                String shortname = fullname.substring(start + 1);
                String sink = String.valueOf(CompiledStylesheetBundle.packageNameToDirectory(packagename, "", '/')) + shortname + ".class";
                ze = new ZipEntry(sink);
                zf.putNextEntry(ze);
                String source = String.valueOf(CompiledStylesheetBundle.packageNameToDirectory(packagename, outdir, File.separatorChar)) + shortname + ".class";
                FileInputStream fis = new FileInputStream(source);
                int count = 0;
                int got = 1;
                while (got >= 0) {
                    got = ((InputStream)fis).read(buffer);
                    if (got <= 0) continue;
                    zf.write(buffer, 0, got);
                    count += got;
                }
                ((InputStream)fis).close();
                ze.setSize(count);
                zf.closeEntry();
                --i;
            }
            ze = new ZipEntry("Stylesheet.ser");
            zf.putNextEntry(ze);
            ObjectOutputStream of = new ObjectOutputStream(zf);
            of.writeObject(root);
            of.flush();
            zf.closeEntry();
            zf.finish();
            ((FilterOutputStream)zf).flush();
            zf.close();
            f.flush();
            f.close();
        }
        catch (IOException e) {
            System.err.println("Exception while bundling compiled stylesheet");
            e.printStackTrace(System.err);
        }
    }

    public Templates loadBundle(String filename) throws IOException, ClassNotFoundException {
        InputStream is = null;
        ObjectInputStream os = null;
        Templates ss = null;
        try {
            ZipfileClassLoader cl = new ZipfileClassLoader(filename, false);
            is = ((ClassLoader)cl).getResourceAsStream("Stylesheet.ser");
            os = new ClassLoaderObjectInputStream(cl, is);
            ss = (Templates)os.readObject();
        }
        finally {
            Object var6_6 = null;
            if (os != null) {
                os.close();
            }
            if (is != null) {
                is.close();
            }
        }
        return ss;
    }

    static String packageNameToDirectory(String packagename, String baseLocation, char separator) {
        int fnstart = baseLocation.lastIndexOf(separator);
        StringBuffer subdir = new StringBuffer(fnstart >= 0 ? baseLocation.substring(0, fnstart + 1) : "");
        subdir.append(packagename.replace('.', separator)).append(separator);
        return subdir.toString();
    }

    class ZipfileClassLoader
    extends ClassLoader {
        ZipFile zip = null;
        Hashtable cache;

        public ZipfileClassLoader(String filename, boolean cached) throws IOException {
            this.zip = new ZipFile(filename);
            if (cached) {
                this.cache = new Hashtable();
            }
        }

        public Class findClass(String name) {
            Class<?> c;
            block2: {
                c = null;
                try {
                    this.getClass();
                    c = Class.forName(name);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    byte[] b = this.loadClassData(name);
                    if (b == null) break block2;
                    c = this.defineClass(name, b, 0, b.length);
                }
            }
            return c;
        }

        public InputStream getResourceAsStream(String name) {
            InputStream is = null;
            try {
                ZipEntry entry = this.zip.getEntry(name);
                is = this.zip.getInputStream(entry);
            }
            catch (IOException e) {
                System.err.println("Problem loading compiled stylesheet");
                e.printStackTrace();
            }
            return is;
        }

        public synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
            Class c;
            Class clazz = c = this.cache == null ? null : (Class)this.cache.get(name);
            if (c == null) {
                c = this.findClass(name);
                if (c != null && resolve) {
                    this.resolveClass(c);
                }
                if (this.cache != null) {
                    this.cache.put(name, c);
                }
            }
            return c;
        }

        private byte[] loadClassData(String name) {
            int start = name.lastIndexOf(".");
            String packagename = name.substring(0, start);
            String shortname = name.substring(start + 1);
            String fn = String.valueOf(CompiledStylesheetBundle.packageNameToDirectory(packagename, "", '/')) + shortname + ".class";
            byte[] data = null;
            try {
                ZipEntry entry = this.zip.getEntry(fn);
                if (entry != null) {
                    int bufsize = (int)entry.getSize();
                    data = new byte[bufsize];
                    InputStream is = this.zip.getInputStream(entry);
                    int len = 0;
                    int off = 0;
                    while (off < bufsize) {
                        len = is.read(data, off, bufsize - off);
                        off += len;
                    }
                    is.close();
                }
            }
            catch (IOException e) {
                System.err.println("Exception while reloading compiled stylesheet");
                e.printStackTrace(System.err);
            }
            return data;
        }
    }

    class ClassLoaderObjectInputStream
    extends ObjectInputStream {
        ClassLoader cl;

        public ClassLoaderObjectInputStream(ClassLoader cl, InputStream is) throws IOException {
            super(is);
            this.cl = cl;
        }

        protected Class resolveClass(ObjectStreamClass v) throws IOException, ClassNotFoundException {
            return this.cl.loadClass(v.getName());
        }
    }
}

