/*
 * Decompiled with CFR 0.152.
 */
package tif.schema.impl.runtime;

import com.sun.xml.bind.JAXBAssertionError;
import com.sun.xml.bind.JAXBObject;
import com.sun.xml.bind.marshaller.IdentifiableObject;
import com.sun.xml.bind.marshaller.Messages;
import com.sun.xml.bind.marshaller.NamespacePrefixMapper;
import com.sun.xml.bind.serializer.AbortSerializationException;
import com.sun.xml.bind.serializer.Util;
import java.util.HashSet;
import java.util.Set;
import javax.xml.bind.JAXBException;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.ValidationEventLocator;
import javax.xml.bind.helpers.NotIdentifiableEventImpl;
import javax.xml.bind.helpers.ValidationEventLocatorImpl;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import tif.schema.impl.runtime.MarshallerImpl;
import tif.schema.impl.runtime.NamespaceContext2;
import tif.schema.impl.runtime.NamespaceContextImpl;
import tif.schema.impl.runtime.PrefixCallback;
import tif.schema.impl.runtime.XMLSerializer;

public class SAXMarshaller
implements XMLSerializer {
    private final AttributesImpl attributes = new AttributesImpl();
    private final ContentHandler writer;
    private final MarshallerImpl owner;
    private final Set idReferencedObjects = new HashSet();
    private final Set objectsWithId = new HashSet();
    private JAXBObject currentTarget;
    private final NamespaceContextImpl nsContext;
    private String[] elementStack = new String[16];
    private int elementLen = 0;
    private final PrefixCallback startPrefixCallback = new PrefixCallback(){

        @Override
        public void onPrefixMapping(String prefix, String nsUri) throws SAXException {
            SAXMarshaller.this.writer.startPrefixMapping(prefix, nsUri);
        }
    };
    private final PrefixCallback endPrefixCallback = new PrefixCallback(){

        @Override
        public void onPrefixMapping(String prefix, String nsUri) throws SAXException {
            SAXMarshaller.this.writer.endPrefixMapping(prefix);
        }
    };
    private final StringBuffer textBuf = new StringBuffer();
    private String attNamespaceUri;
    private String attLocalName;
    private static NamespacePrefixMapper defaultNamespacePrefixMapper = new NamespacePrefixMapper(){

        public String getPreferredPrefix(String namespaceUri, String suggestion, boolean requirePrefix) {
            if (namespaceUri.equals("http://www.w3.org/2001/XMLSchema-instance")) {
                return "xsi";
            }
            return suggestion;
        }
    };

    public SAXMarshaller(ContentHandler _writer, NamespacePrefixMapper prefixMapper, MarshallerImpl _owner) {
        this.writer = _writer;
        this.owner = _owner;
        this.nsContext = new NamespaceContextImpl(prefixMapper != null ? prefixMapper : defaultNamespacePrefixMapper);
    }

    @Override
    public NamespaceContext2 getNamespaceContext() {
        return this.nsContext;
    }

    private void pushElement(String uri, String local) {
        if (this.elementStack.length == this.elementLen) {
            String[] buf = new String[this.elementStack.length * 2];
            System.arraycopy(this.elementStack, 0, buf, 0, this.elementStack.length);
            this.elementStack = buf;
        }
        this.elementStack[this.elementLen++] = uri;
        this.elementStack[this.elementLen++] = local;
    }

    private void popElement() {
        this.elementLen -= 2;
    }

    private String getCurrentElementUri() {
        return this.elementStack[this.elementLen - 2];
    }

    private String getCurrentElementLocal() {
        return this.elementStack[this.elementLen - 1];
    }

    @Override
    public void startElement(String uri, String local) throws SAXException {
        String[] uris;
        boolean isRoot = false;
        String suggestion = null;
        if (this.elementLen == 0) {
            isRoot = true;
            suggestion = "";
        }
        this.writePendingText();
        this.nsContext.startElement();
        this.pushElement(uri, local);
        this.nsContext.declareNamespace(uri, suggestion, false);
        if (isRoot && (uris = this.nsContext.getNamespacePrefixMapper().getPreDeclaredNamespaceUris()) != null) {
            int i = 0;
            while (i < uris.length) {
                if (uris[i] != null) {
                    this.nsContext.declareNamespace(uris[i], null, false);
                }
                ++i;
            }
        }
    }

    @Override
    public void endNamespaceDecls() throws SAXException {
        this.nsContext.endNamespaceDecls();
    }

    @Override
    public void endAttributes() throws SAXException {
        String uri = this.getCurrentElementUri();
        String local = this.getCurrentElementLocal();
        String prefix = this.nsContext.getPrefix(uri);
        SAXMarshaller._assert(prefix != null);
        String qname = prefix.length() != 0 ? String.valueOf(prefix) + ':' + local : local;
        this.nsContext.iterateDeclaredPrefixes(this.startPrefixCallback);
        this.writer.startElement(uri, local, qname, this.attributes);
        this.attributes.clear();
        this.textBuf.setLength(0);
    }

    @Override
    public void endElement() throws SAXException {
        this.writePendingText();
        String uri = this.getCurrentElementUri();
        String local = this.getCurrentElementLocal();
        String prefix = this.nsContext.getPrefix(uri);
        SAXMarshaller._assert(prefix != null);
        String qname = prefix.length() != 0 ? String.valueOf(prefix) + ':' + local : local;
        this.writer.endElement(uri, local, qname);
        this.nsContext.iterateDeclaredPrefixes(this.endPrefixCallback);
        this.popElement();
        this.textBuf.setLength(0);
        this.nsContext.endElement();
    }

    @Override
    public void text(String text, String fieldName) throws SAXException {
        if (text == null) {
            this.reportError(Util.createMissingObjectError((Object)this.currentTarget, (String)fieldName));
            return;
        }
        if (this.textBuf.length() != 0) {
            this.textBuf.append(' ');
        }
        this.textBuf.append(text);
    }

    private void writePendingText() throws SAXException {
        int len = this.textBuf.length();
        if (len != 0) {
            this.writer.characters(this.textBuf.toString().toCharArray(), 0, len);
        }
    }

    @Override
    public void startAttribute(String uri, String local) {
        this.textBuf.setLength(0);
        this.attNamespaceUri = uri;
        this.attLocalName = local;
    }

    @Override
    public void endAttribute() {
        String qname = this.attNamespaceUri.length() == 0 ? this.attLocalName : String.valueOf(this.nsContext.declareNamespace(this.attNamespaceUri, null, true)) + ':' + this.attLocalName;
        this.attributes.addAttribute(this.attNamespaceUri, this.attLocalName, qname, "CDATA", this.textBuf.toString());
    }

    @Override
    public String onID(IdentifiableObject owner, String value) throws SAXException {
        this.objectsWithId.add(owner);
        return value;
    }

    @Override
    public String onIDREF(IdentifiableObject obj) throws SAXException {
        this.idReferencedObjects.add(obj);
        String id = obj.____jaxb____getId();
        if (id == null) {
            this.reportError((ValidationEvent)new NotIdentifiableEventImpl(1, Messages.format((String)"SAXMarshaller.NotIdentifiable"), (ValidationEventLocator)new ValidationEventLocatorImpl((Object)obj)));
        }
        return id;
    }

    void reconcileID() throws AbortSerializationException {
        this.idReferencedObjects.removeAll(this.objectsWithId);
        for (IdentifiableObject o : this.idReferencedObjects) {
            this.reportError((ValidationEvent)new NotIdentifiableEventImpl(1, Messages.format((String)"SAXMarshaller.DanglingIDREF", (Object)o.____jaxb____getId()), (ValidationEventLocator)new ValidationEventLocatorImpl((Object)o)));
        }
        this.idReferencedObjects.clear();
        this.objectsWithId.clear();
    }

    @Override
    public void childAsBody(JAXBObject o, String fieldName) throws SAXException {
        if (o == null) {
            this.reportMissingObjectError(fieldName);
            return;
        }
        JAXBObject oldTarget = this.currentTarget;
        this.currentTarget = o;
        this.owner.context.getGrammarInfo().castToXMLSerializable(o).serializeBody(this);
        this.currentTarget = oldTarget;
    }

    @Override
    public void childAsAttributes(JAXBObject o, String fieldName) throws SAXException {
        if (o == null) {
            this.reportMissingObjectError(fieldName);
            return;
        }
        JAXBObject oldTarget = this.currentTarget;
        this.currentTarget = o;
        this.owner.context.getGrammarInfo().castToXMLSerializable(o).serializeAttributes(this);
        this.currentTarget = oldTarget;
    }

    @Override
    public void childAsURIs(JAXBObject o, String fieldName) throws SAXException {
        if (o == null) {
            this.reportMissingObjectError(fieldName);
            return;
        }
        JAXBObject oldTarget = this.currentTarget;
        this.currentTarget = o;
        this.owner.context.getGrammarInfo().castToXMLSerializable(o).serializeURIs(this);
        this.currentTarget = oldTarget;
    }

    @Override
    public void reportError(ValidationEvent ve) throws AbortSerializationException {
        ValidationEventHandler handler;
        try {
            handler = this.owner.getEventHandler();
        }
        catch (JAXBException e) {
            throw new AbortSerializationException((Exception)((Object)e));
        }
        if (!handler.handleEvent(ve)) {
            if (ve.getLinkedException() instanceof Exception) {
                throw new AbortSerializationException((Exception)ve.getLinkedException());
            }
            throw new AbortSerializationException(ve.getMessage());
        }
    }

    public void reportMissingObjectError(String fieldName) throws SAXException {
        this.reportError(Util.createMissingObjectError((Object)this.currentTarget, (String)fieldName));
    }

    private static void _assert(boolean b) {
        if (!b) {
            throw new JAXBAssertionError();
        }
    }
}

