/*
 * Decompiled with CFR 0.152.
 */
package sms.soap;

import ProcesadorDocumentos.XMLHelpers.AttrContainer;
import ProcesadorDocumentos.XMLHelpers.ContainerItem;
import ProcesadorDocumentos.XMLHelpers.documentWrapper;
import java.io.File;
import sms.soap.TipoDocumento;

public class Config {
    private static String usuario = null;
    private static String password = null;
    private static String servidor = null;
    private static String url = null;
    private static String home = null;
    private static String nombreServidor = null;
    private static String proxyUserName = null;
    private static String proxyPassword = null;
    private static String proxyHost = null;
    private static String proxyPort = null;
    private static String protocolo = null;

    public Config(String home) throws Exception {
        Config.home = home;
        documentWrapper doc = null;
        File fhome = new File(home);
        if (!fhome.exists()) {
            throw new Exception("\tEl directorio " + fhome.getPath() + " no existe");
        }
        File fserver = new File(String.valueOf(home) + "/conf/datos-servidor.xml");
        if (!fserver.exists()) {
            throw new Exception("\tEl archivo " + fserver.getPath() + " no existe");
        }
        doc = new documentWrapper(fserver);
        proxyUserName = doc.getAttribute("proxy-user-name");
        proxyPassword = doc.getAttribute("proxy-password");
        proxyHost = doc.getAttribute("proxy-host");
        proxyPort = doc.getAttribute("proxy-port");
        AttrContainer conexion = doc.getContainer("conexiones-soap");
        servidor = conexion.getItem(0).getAttribute("servidor");
        nombreServidor = conexion.getItem(0).getAttribute("nombre");
        url = String.valueOf(conexion.getItem(0).getAttribute("protocolo")) + "://" + servidor;
        protocolo = conexion.getItem(0).getAttribute("protocolo");
        File fuser = new File(String.valueOf(home) + "/conf/privados.xml");
        if (!fuser.exists()) {
            throw new Exception("\tEl archivo " + fuser.getPath() + " no existe");
        }
        doc = new documentWrapper(fuser);
        usuario = doc.getAttribute("login");
        password = doc.getAttribute("clave");
    }

    public TipoDocumento getTipoDocumento(String codigo, String version, ContainerItem docServidor) {
        if (docServidor == null) {
            return null;
        }
        AttrContainer tiposDocumentos = docServidor.getContainer("tipos-documentos");
        if (tiposDocumentos == null) {
            return null;
        }
        int i = 0;
        while (i < tiposDocumentos.size()) {
            ContainerItem d = tiposDocumentos.getItem(i);
            if (d.getAttribute("codigo") != null && d.getAttribute("codigo").equals(codigo) && d.getAttribute("version").equals(version)) {
                return new TipoDocumento(this, d);
            }
            ++i;
        }
        return null;
    }

    public TipoDocumento getTipoDocumento(String codigo, String version) {
        documentWrapper doc = null;
        try {
            doc = this.getDoc();
        }
        catch (Exception E) {
            return null;
        }
        TipoDocumento ret = this.getTipoDocumento(codigo, version, (ContainerItem)doc);
        return ret;
    }

    public documentWrapper getDoc() throws Exception {
        String path = String.valueOf(this.getHome()) + "/conf/datos-servidor.xml";
        File f = new File(path);
        if (!f.exists()) {
            return null;
        }
        return new documentWrapper(f);
    }

    public void creaDatosServidor(String proxyPort, String proxyHost, String proxyUser, String proxyPass) {
        try {
            documentWrapper file = new documentWrapper(new File(String.valueOf(home) + "\\conf\\datos-servidor.xml"));
            file.setAttribute("proxy-host", proxyHost);
            file.setAttribute("proxy-port", proxyPort);
            file.setAttribute("proxy-user-name", proxyUser);
            file.setAttribute("proxy-password", proxyPass);
            file.saveToFile(new File(String.valueOf(home) + "\\conf\\datos-servidor.xml"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void creaPrivados(String login, String clave) {
        try {
            documentWrapper file = new documentWrapper(new File(String.valueOf(home) + "\\conf\\privados.xml"));
            file.setAttribute("login", login);
            file.setAttribute("clave", clave);
            file.saveToFile(new File(String.valueOf(home) + "\\conf\\privados.xml"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getServidor() {
        return servidor;
    }

    public String getUrl() {
        return url;
    }

    public String getUsuario() {
        return usuario;
    }

    public String getPassword() {
        return password;
    }

    public String getNombreServidor() {
        return nombreServidor;
    }

    public String getHome() {
        return home;
    }

    public String getUsuarioProxy() {
        return proxyUserName;
    }

    public String getPasswordProxy() {
        return proxyPassword;
    }

    public String getHostProxy() {
        return proxyHost;
    }

    public String getPortProxy() {
        return proxyPort;
    }

    public String getProtocolo() {
        return protocolo;
    }
}

