/*
 * Decompiled with CFR 0.152.
 */
package sms.soap;

import ProcesadorDocumentos.XMLHelpers.AttrContainer;
import ProcesadorDocumentos.XMLHelpers.ContainerItem;
import ProcesadorDocumentos.XMLHelpers.documentWrapper;
import java.io.ByteArrayOutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.Inflater;
import org.apache.soap.SOAPException;
import org.apache.soap.rpc.Call;
import org.apache.soap.rpc.Parameter;
import org.apache.soap.rpc.Response;
import org.apache.soap.transport.SOAPTransport;
import org.apache.soap.transport.http.SOAPHTTPConnection;
import sms.soap.Documento;
import sms.util.Util;

public class ServidorSOAP {
    private String proxyUserName = null;
    private String proxyPassword = null;
    private String proxyHost = null;
    private String proxyPort = null;
    private String strUrl = null;
    private boolean useProxy = false;
    private Parameter sss = null;

    public ServidorSOAP(String strUrl, boolean useProxy) throws Exception {
        if (strUrl == null) {
            throw new Exception("Par\u00c3\u00a1metro strUrl no puede ser nulo");
        }
        this.strUrl = String.valueOf(strUrl) + Util.getServiceName();
        this.useProxy = useProxy;
    }

    public documentWrapper consultaDocumento(Documento documento, String user, String password) throws Exception {
        String[] nombreParametros = new String[]{"DocType", "Reference", "User", "Pwd"};
        String[] valorParametros = new String[]{documento.getTipoDocumento().getCodigo(), documento.getDocXML().getAttribute("numero-referencia"), user, password};
        String ret = (String)this.invocaServicio("getDocQueueStatus", nombreParametros, valorParametros);
        return new documentWrapper(ret);
    }

    public void enviaDocumento(Documento documento, String user, String password) throws Exception {
        String marca = "";
        marca = !documento.getDocXML().getDocType().equals("GR") ? "numero-referencia" : "numero-guia";
        String[] nombreParametros = new String[]{"login", "clave", "numeroReferencia", "xml"};
        String[] valorParametros = new String[]{user, password, documento.getDocXML().getAttribute(marca), documento.getDocXML().toXMLOnlyData()};
        this.invocaServicio("enviaDocumento", nombreParametros, valorParametros);
    }

    public documentWrapper getXMLDocumento(String user, String password, Documento documento) throws Exception {
        String[] nombreParametros = new String[]{"login", "clave", "Id"};
        Long id = documento.getDocXML().getLongAttribute("id-documento-servidor");
        if (id == null) {
            throw new Exception("El documento no tiene el atributo id-documento-servidor. No se puede descargar una nueva versi\u00c3\u00b3n desde el servidor");
        }
        String[] valorParametros = new String[]{user, password, id.toString()};
        try {
            String ret = (String)this.invocaServicio("getXMLDocumento", nombreParametros, valorParametros);
            documentWrapper r = new documentWrapper(ret);
            if (!r.getDocType().trim().equals(documento.getDocXML().getDocType())) {
                throw new Exception(r.getAttribute("Mensaje"));
            }
            return r;
        }
        catch (Exception E) {
            E.printStackTrace();
            throw new Exception("No se puede descargar una nueva versi\u00c3\u00b3n del documento desde el servidor.\nEl error retornado es: " + E.getMessage());
        }
    }

    public int isUserValido(String user, String pwd) {
        int valid = 0;
        String retValue = "false";
        String[] nmParam = new String[]{"user", "pwd"};
        String[] valParam = new String[]{user, pwd};
        try {
            retValue = (String)this.invocaServicio("validaUser", nmParam, valParam);
            if (retValue.equals("true")) {
                valid = 1;
            } else if (retValue.equals("op_no_vigente")) {
                valid = 3;
            }
        }
        catch (Exception e) {
            valid = 2;
            e.printStackTrace();
        }
        return valid;
    }

    public String isUserAlmacenista(String user, String pwd) {
        String retValue = new String();
        String[] nmParam = new String[]{"user", "pwd"};
        String[] valParam = new String[]{user, pwd};
        try {
            retValue = (String)this.invocaServicio("validaAlmacenista", nmParam, valParam);
        }
        catch (Exception e) {
            retValue = "-1";
            e.printStackTrace();
        }
        return retValue;
    }

    public String isUserFiscalizador(String user, String pwd) {
        String retValue = new String();
        String[] nmParam = new String[]{"user", "pwd"};
        String[] valParam = new String[]{user, pwd};
        try {
            retValue = (String)this.invocaServicio("validaFiscalizador", nmParam, valParam);
        }
        catch (Exception e) {
            retValue = "-1";
            e.printStackTrace();
        }
        return retValue;
    }

    public Vector getDocsTramitados(String user, String pwd, String fcDesde, String fcHasta, String tpDoc, String version) {
        Vector<Object> retValue = new Vector<Object>();
        String[] nmParam = new String[]{"user", "pwd", "fcDesde", "fcHasta", "tpDoc", "version"};
        String[] valParam = new String[]{user, pwd, fcDesde, fcHasta, tpDoc, version};
        try {
            byte[] input = this.descomprimeDato((byte[])this.invocaServicio("getDocsTramitadosxFecha", nmParam, valParam));
            if (input.length > 0) {
                retValue.add("cabecera");
                String tmp = new String(input);
                documentWrapper docW = new documentWrapper(tmp);
                if (docW.existContainer("Registros")) {
                    AttrContainer atc = docW.getContainer("Registros");
                    Enumeration enm = atc.getItems();
                    while (enm.hasMoreElements()) {
                        ContainerItem ci = (ContainerItem)enm.nextElement();
                        Properties prop = ci.getAttributes();
                        Hashtable<String, Object> reg = new Hashtable<String, Object>();
                        reg.put("nroRef", prop.get("nroRef"));
                        reg.put("estado", prop.get("estado"));
                        reg.put("idServ", prop.get("idServ"));
                        reg.put("fecha", prop.get("fecha"));
                        reg.put("nroRefOrig", prop.get("nroRefOrig"));
                        reg.put("fcAceptacion", prop.get("fcAceptacion"));
                        reg.put("version", prop.get("version"));
                        reg.put("nmNave", prop.get("nmNave"));
                        reg.put("tipoAccion", prop.get("tipoAccion"));
                        reg.put("situacion", prop.get("situacion"));
                        reg.put("idImagen", prop.get("idImagen"));
                        reg.put("codEstado", prop.get("codEstado"));
                        retValue.add(reg);
                    }
                }
            } else {
                retValue.add("cabecera");
            }
        }
        catch (Exception e) {
            retValue.add("error");
            e.printStackTrace();
        }
        return retValue;
    }

    public Vector getDocsTramitadosxMF(String user, String pwd, String versionDocOrigen, String tpDocOrigen, String nrDocDestino, String tpDocDestino) {
        Vector<Object> retValue = new Vector<Object>();
        String[] nmParam = new String[]{"user", "pwd", "versionDocOrigen", "tpDocOrigen", "nrDocDestino", "tpDocDestino"};
        String[] valParam = new String[]{user, pwd, versionDocOrigen, tpDocOrigen, nrDocDestino, tpDocDestino};
        try {
            byte[] input = this.descomprimeDato((byte[])this.invocaServicio("getDocsTramitadosxMF", nmParam, valParam));
            if (input.length > 0) {
                retValue.add("cabecera");
                String tmp = new String(input);
                documentWrapper docW = new documentWrapper(tmp);
                if (docW.existContainer("Registros")) {
                    AttrContainer atc = docW.getContainer("Registros");
                    Enumeration enm = atc.getItems();
                    while (enm.hasMoreElements()) {
                        ContainerItem ci = (ContainerItem)enm.nextElement();
                        Properties prop = ci.getAttributes();
                        Hashtable<String, Object> reg = new Hashtable<String, Object>();
                        reg.put("nroRef", prop.get("nroRef"));
                        reg.put("estado", prop.get("estado"));
                        reg.put("idServ", prop.get("idServ"));
                        reg.put("fecha", prop.get("fecha"));
                        reg.put("nroRefOrig", prop.get("nroRefOrig"));
                        reg.put("fcAceptacion", prop.get("fcAceptacion"));
                        reg.put("version", prop.get("version"));
                        reg.put("nmNave", prop.get("nmNave"));
                        reg.put("tipoAccion", prop.get("tipoAccion"));
                        reg.put("situacion", prop.get("situacion"));
                        reg.put("idImagen", prop.get("idImagen"));
                        reg.put("codEstado", prop.get("codEstado"));
                        reg.put("fcEfectiva", prop.get("fcEfectiva"));
                        reg.put("mfto", prop.get("mfto"));
                        reg.put("fcAceptacionMF", prop.get("fcAceptacionMF"));
                        reg.put("tpOperacion", prop.get("tpOperacion"));
                        reg.put("idServMF", prop.get("idServMF"));
                        reg.put("estadoMF", prop.get("estadoMF"));
                        retValue.add(reg);
                    }
                }
            } else {
                retValue.add("cabecera");
            }
        }
        catch (Exception e) {
            retValue.add("error");
            e.printStackTrace();
        }
        return retValue;
    }

    public Vector getDocsTramitadosALMxMF(String user, String pwd, String versionDocOrigen, String tpDocOrigen, String tpDocDestino, String nrDocDestino, String idAlm) {
        Vector<Object> retValue = new Vector<Object>();
        String[] nmParam = new String[]{"user", "pwd", "versionDocOrigen", "tpDocOrigen", "tpDocDestino", "nrDocDestino", "idAlm"};
        String[] valParam = new String[]{user, pwd, versionDocOrigen, tpDocOrigen, tpDocDestino, nrDocDestino, idAlm};
        try {
            byte[] input = this.descomprimeDato((byte[])this.invocaServicio("getDocsTramitadosALMxMF", nmParam, valParam));
            if (input.length > 0) {
                retValue.add("cabecera");
                String tmp = new String(input);
                documentWrapper docW = new documentWrapper(tmp);
                if (docW.existContainer("Registros")) {
                    AttrContainer atc = docW.getContainer("Registros");
                    Enumeration enm = atc.getItems();
                    while (enm.hasMoreElements()) {
                        ContainerItem ci = (ContainerItem)enm.nextElement();
                        Properties prop = ci.getAttributes();
                        Hashtable<String, Object> reg = new Hashtable<String, Object>();
                        reg.put("nroRef", prop.get("nroRef"));
                        reg.put("estado", prop.get("estado"));
                        reg.put("idServ", prop.get("idServ"));
                        reg.put("fecha", prop.get("fecha"));
                        reg.put("nroRefOrig", prop.get("nroRefOrig"));
                        reg.put("fcAceptacion", prop.get("fcAceptacion"));
                        reg.put("version", prop.get("version"));
                        reg.put("nmNave", prop.get("nmNave"));
                        reg.put("tipoAccion", prop.get("tipoAccion"));
                        reg.put("situacion", prop.get("situacion"));
                        reg.put("idImagen", prop.get("idImagen"));
                        reg.put("codEstado", prop.get("codEstado"));
                        reg.put("usuario", prop.get("usuario"));
                        retValue.add(reg);
                    }
                }
            } else {
                retValue.add("cabecera");
            }
        }
        catch (Exception e) {
            retValue.add("error");
            e.printStackTrace();
        }
        return retValue;
    }

    public Vector getDocsTramitadosFISCxMF(String user, String pwd, String versionDocOrigen, String tpDocOrigen, String tpDocDestino, String nrDocDestino) {
        Vector<Object> retValue = new Vector<Object>();
        String[] nmParam = new String[]{"user", "pwd", "versionDocOrigen", "tpDocOrigen", "tpDocDestino", "nrDocDestino"};
        String[] valParam = new String[]{user, pwd, versionDocOrigen, tpDocOrigen, tpDocDestino, nrDocDestino};
        try {
            byte[] input = this.descomprimeDato((byte[])this.invocaServicio("getDocsTramitadosFISCxMF", nmParam, valParam));
            if (input.length > 0) {
                retValue.add("cabecera");
                String tmp = new String(input);
                documentWrapper docW = new documentWrapper(tmp);
                if (docW.existContainer("Registros")) {
                    AttrContainer atc = docW.getContainer("Registros");
                    Enumeration enm = atc.getItems();
                    while (enm.hasMoreElements()) {
                        ContainerItem ci = (ContainerItem)enm.nextElement();
                        Properties prop = ci.getAttributes();
                        Hashtable<String, Object> reg = new Hashtable<String, Object>();
                        reg.put("nroRefOrig", prop.get("nroRefOrig"));
                        reg.put("nroRef", prop.get("nroRef"));
                        reg.put("estado", prop.get("estado"));
                        reg.put("codEstado", prop.get("codEstado"));
                        reg.put("fecha", prop.get("fecha"));
                        reg.put("idServ", prop.get("idServ"));
                        reg.put("version", prop.get("version"));
                        reg.put("tipoAccion", prop.get("tipoAccion"));
                        reg.put("situacion", prop.get("situacion"));
                        reg.put("usuario", prop.get("usuario"));
                        reg.put("idImagen", prop.get("idImagen"));
                        retValue.add(reg);
                    }
                }
            } else {
                retValue.add("cabecera");
            }
        }
        catch (Exception e) {
            retValue.add("error");
            e.printStackTrace();
        }
        return retValue;
    }

    public Vector getDocsTramitadosPorEstado(String user, String pwd, String fcDesde, String fcHasta, String tpDoc, String version, String tpEstado) {
        Vector<Object> retValue = new Vector<Object>();
        String[] nmParam = new String[]{"user", "pwd", "fcDesde", "fcHasta", "tpDoc", "version", "tpEstado"};
        String[] valParam = new String[]{user, pwd, fcDesde, fcHasta, tpDoc, version, tpEstado};
        try {
            byte[] input = this.descomprimeDato((byte[])this.invocaServicio("getDocsTramitadosxEstado", nmParam, valParam));
            if (input.length > 0) {
                retValue.add("cabecera");
                String tmp = new String(input);
                documentWrapper docW = new documentWrapper(tmp);
                if (docW.existContainer("Registros")) {
                    AttrContainer atc = docW.getContainer("Registros");
                    Enumeration enm = atc.getItems();
                    while (enm.hasMoreElements()) {
                        ContainerItem ci = (ContainerItem)enm.nextElement();
                        Properties prop = ci.getAttributes();
                        Hashtable<String, Object> reg = new Hashtable<String, Object>();
                        reg.put("nroRef", prop.get("nroRef"));
                        reg.put("estado", prop.get("estado"));
                        reg.put("idServ", prop.get("idServ"));
                        reg.put("fecha", prop.get("fecha"));
                        reg.put("nroRefOrig", prop.get("nroRefOrig"));
                        reg.put("fcAceptacion", prop.get("fcAceptacion"));
                        reg.put("version", prop.get("version"));
                        reg.put("nmNave", prop.get("nmNave"));
                        reg.put("tipoAccion", prop.get("tipoAccion"));
                        reg.put("situacion", prop.get("situacion"));
                        reg.put("idImagen", prop.get("idImagen"));
                        reg.put("codEstado", prop.get("codEstado"));
                        retValue.add(reg);
                    }
                }
            } else {
                retValue.add("cabecera");
            }
        }
        catch (Exception e) {
            retValue.add("error");
            e.printStackTrace();
        }
        return retValue;
    }

    public Vector getDocsTramitadosAlm(String user, String pwd, String idAlm, String fcDesde, String fcHasta, String tpDoc, String version) {
        Vector<Object> retValue = new Vector<Object>();
        String[] nmParam = new String[]{"user", "pwd", "idAlm", "fcDesde", "fcHasta", "tpDoc", "version"};
        String[] valParam = new String[]{user, pwd, idAlm, fcDesde, fcHasta, tpDoc, version};
        try {
            byte[] input = this.descomprimeDato((byte[])this.invocaServicio("getDocsTramitadosAlm", nmParam, valParam));
            if (input.length > 0) {
                retValue.add("cabecera");
                String tmp = new String(input);
                documentWrapper docW = new documentWrapper(tmp);
                if (docW.existContainer("Registros")) {
                    AttrContainer atc = docW.getContainer("Registros");
                    Enumeration enm = atc.getItems();
                    while (enm.hasMoreElements()) {
                        ContainerItem ci = (ContainerItem)enm.nextElement();
                        Properties prop = ci.getAttributes();
                        Hashtable<String, Object> reg = new Hashtable<String, Object>();
                        reg.put("nroRefOrig", prop.get("nroRefOrig"));
                        reg.put("nroRef", prop.get("nroRef"));
                        reg.put("estado", prop.get("estado"));
                        reg.put("codEstado", prop.get("codEstado"));
                        reg.put("fecha", prop.get("fecha"));
                        reg.put("idServ", prop.get("idServ"));
                        reg.put("version", prop.get("version"));
                        reg.put("tipoAccion", prop.get("tipoAccion"));
                        reg.put("situacion", prop.get("situacion"));
                        reg.put("usuario", prop.get("usuario"));
                        reg.put("idImagen", prop.get("idImagen"));
                        retValue.add(reg);
                    }
                }
            } else {
                retValue.add("cabecera");
            }
        }
        catch (Exception e) {
            retValue.add("error");
            e.printStackTrace();
        }
        return retValue;
    }

    public Vector getDocsTramitadosFISC(String user, String pwd, String fcDesde, String fcHasta, String tpDoc, String version) {
        Vector<Object> retValue = new Vector<Object>();
        String[] nmParam = new String[]{"user", "pwd", "fcDesde", "fcHasta", "tpDoc", "version"};
        String[] valParam = new String[]{user, pwd, fcDesde, fcHasta, tpDoc, version};
        try {
            byte[] input = this.descomprimeDato((byte[])this.invocaServicio("getDocsTramitadosFISCxFecha", nmParam, valParam));
            if (input.length > 0) {
                retValue.add("cabecera");
                String tmp = new String(input);
                documentWrapper docW = new documentWrapper(tmp);
                if (docW.existContainer("Registros")) {
                    AttrContainer atc = docW.getContainer("Registros");
                    Enumeration enm = atc.getItems();
                    while (enm.hasMoreElements()) {
                        ContainerItem ci = (ContainerItem)enm.nextElement();
                        Properties prop = ci.getAttributes();
                        Hashtable<String, Object> reg = new Hashtable<String, Object>();
                        reg.put("nroRefOrig", prop.get("nroRefOrig"));
                        reg.put("nroRef", prop.get("nroRef"));
                        reg.put("estado", prop.get("estado"));
                        reg.put("codEstado", prop.get("codEstado"));
                        reg.put("fecha", prop.get("fecha"));
                        reg.put("idServ", prop.get("idServ"));
                        reg.put("version", prop.get("version"));
                        reg.put("tipoAccion", prop.get("tipoAccion"));
                        reg.put("situacion", prop.get("situacion"));
                        reg.put("usuario", prop.get("usuario"));
                        reg.put("idImagen", prop.get("idImagen"));
                        retValue.add(reg);
                    }
                }
            } else {
                retValue.add("cabecera");
            }
        }
        catch (Exception e) {
            retValue.add("error");
            e.printStackTrace();
        }
        return retValue;
    }

    public Vector getDocTramitadoHist(String user, String pwd, String nroRef, String tpDoc, String version) {
        Vector<Object> retValue = new Vector<Object>();
        String[] nmParam = new String[]{"user", "pwd", "nroRef", "tpDoc", "version"};
        String[] valParam = new String[]{user, pwd, nroRef, tpDoc, version};
        try {
            byte[] input = this.descomprimeDato((byte[])this.invocaServicio("getDocTramitadoHist", nmParam, valParam));
            if (input.length > 0) {
                retValue.add("cabecera");
                String tmp = new String(input);
                documentWrapper docW = new documentWrapper(tmp);
                if (docW.existContainer("Registros")) {
                    AttrContainer atc = docW.getContainer("Registros");
                    Enumeration enm = atc.getItems();
                    while (enm.hasMoreElements()) {
                        ContainerItem ci = (ContainerItem)enm.nextElement();
                        Properties prop = ci.getAttributes();
                        Hashtable<String, Object> reg = new Hashtable<String, Object>();
                        reg.put("nroRef", prop.get("nroRef"));
                        reg.put("estado", prop.get("estado"));
                        reg.put("idServ", prop.get("idServ"));
                        reg.put("fecha", prop.get("fecha"));
                        reg.put("nroRefOrig", prop.get("nroRefOrig"));
                        reg.put("fcAceptacion", prop.get("fcAceptacion"));
                        reg.put("version", prop.get("version"));
                        reg.put("nmNave", prop.get("nmNave"));
                        reg.put("tipoAccion", prop.get("tipoAccion"));
                        reg.put("idImagen", prop.get("idImagen"));
                        reg.put("codEstado", prop.get("codEstado"));
                        reg.put("fcEfectiva", prop.get("fcEfectiva"));
                        retValue.add(reg);
                    }
                }
            } else {
                retValue.add("cabecera");
            }
        }
        catch (Exception e) {
            retValue.add("error");
            e.printStackTrace();
        }
        return retValue;
    }

    public Vector getDocTramitado(String user, String pwd, String nroRef, String tpDoc, String version, String idImagen, String tpAccion) {
        Vector<Object> retValue = new Vector<Object>();
        String[] nmParam = new String[]{"user", "pwd", "nroRef", "tpDoc", "version", "idImagen", "tpAccion"};
        String[] valParam = new String[]{user, pwd, nroRef, tpDoc, version, idImagen, tpAccion};
        try {
            byte[] input = this.descomprimeDato((byte[])this.invocaServicio("getDocTramitadoxNro", nmParam, valParam));
            if (input.length > 0) {
                retValue.add("cabecera");
                String tmp = new String(input);
                documentWrapper docW = new documentWrapper(tmp);
                if (docW.existContainer("Registros")) {
                    AttrContainer atc = docW.getContainer("Registros");
                    Enumeration enm = atc.getItems();
                    while (enm.hasMoreElements()) {
                        ContainerItem ci = (ContainerItem)enm.nextElement();
                        Properties prop = ci.getAttributes();
                        Hashtable<String, Object> reg = new Hashtable<String, Object>();
                        reg.put("nroRef", prop.get("nroRef"));
                        reg.put("estado", prop.get("estado"));
                        reg.put("idServ", prop.get("idServ"));
                        reg.put("fecha", prop.get("fecha"));
                        reg.put("nroRefOrig", prop.get("nroRefOrig"));
                        reg.put("fcAceptacion", prop.get("fcAceptacion"));
                        reg.put("version", prop.get("version"));
                        reg.put("nmNave", prop.get("nmNave"));
                        reg.put("tipoAccion", prop.get("tipoAccion"));
                        reg.put("idImagen", prop.get("idImagen"));
                        reg.put("codEstado", prop.get("codEstado"));
                        reg.put("fcEfectiva", prop.get("fcEfectiva"));
                        retValue.add(reg);
                    }
                }
            } else {
                retValue.add("cabecera");
            }
        }
        catch (Exception e) {
            retValue.add("error");
            e.printStackTrace();
        }
        return retValue;
    }

    public String getDocsAprobados(String user, String pwd, String idServ) {
        String retValue = "";
        String[] nmParam = new String[]{"user", "pwd", "idServ"};
        String[] valParam = new String[]{user, pwd, idServ};
        try {
            byte[] input = this.descomprimeDato((byte[])this.invocaServicio("getXMLDocAprobado", nmParam, valParam));
            if (input != null) {
                retValue = new String(input);
            }
        }
        catch (Exception e) {
            retValue = "error";
            e.printStackTrace();
        }
        return retValue;
    }

    public String getDocsAprobadosxId(String user, String pwd, String idServ, String idDoc) {
        String retValue = "";
        String[] nmParam = new String[]{"user", "pwd", "idServ", "idDoc"};
        String[] valParam = new String[]{user, pwd, idServ, idDoc};
        try {
            byte[] input = this.descomprimeDato((byte[])this.invocaServicio("getXMLDocAprobadoxId", nmParam, valParam));
            if (input != null) {
                retValue = new String(input);
            }
        }
        catch (Exception e) {
            retValue = "error";
            e.printStackTrace();
        }
        return retValue;
    }

    public Vector getDetLogDocsRechazados(String user, String pwd, String nroRef, String tpDoc) {
        Vector<String> retValue = new Vector<String>();
        String[] nmParam = new String[]{"user", "pwd", "nroRef", "tpDoc"};
        String[] valParam = new String[]{user, pwd, nroRef, tpDoc};
        try {
            String tmp = (String)this.invocaServicio("getLogDocRechazado", nmParam, valParam);
            if (tmp.length() > 0) {
                retValue.add("cabecera");
                StringTokenizer st = new StringTokenizer(tmp, "###");
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    retValue.add(token);
                }
            } else {
                retValue.add("cabecera");
            }
        }
        catch (Exception e) {
            retValue.add("error");
            e.printStackTrace();
        }
        return retValue;
    }

    public Vector getDetLogDocsRechazados(String user, String pwd, String usuario, String nroRef, String tpDoc) {
        Vector<String> retValue = new Vector<String>();
        String[] nmParam = new String[]{"user", "pwd", "usuario", "nroRef", "tpDoc"};
        String[] valParam = new String[]{user, pwd, usuario, nroRef, tpDoc};
        try {
            String tmp = (String)this.invocaServicio("getLogDocRechazadoxUsuario", nmParam, valParam);
            if (tmp.length() > 0) {
                retValue.add("cabecera");
                StringTokenizer st = new StringTokenizer(tmp, "###");
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    retValue.add(token);
                }
            } else {
                retValue.add("cabecera");
            }
        }
        catch (Exception e) {
            retValue.add("error");
            e.printStackTrace();
        }
        return retValue;
    }

    public byte[] descomprimeDato(byte[] bIn) {
        Inflater decompressor = new Inflater();
        decompressor.setInput(bIn);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(bIn.length);
        byte[] buf = new byte[1024];
        while (!decompressor.finished()) {
            try {
                int count = decompressor.inflate(buf);
                bos.write(buf, 0, count);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            bos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bos.toByteArray();
    }

    public Vector getDatosSoftware(String user, String pwd, String codSoft, String estado) {
        Vector<Object> retValue = new Vector<Object>();
        String[] nmParam = new String[]{"user", "pwd", "codSoft", "estado"};
        String[] valParam = new String[]{user, pwd, codSoft, estado};
        try {
            byte[] input = this.descomprimeDato((byte[])this.invocaServicio("getVersionSMDT", nmParam, valParam));
            if (input.length > 0) {
                retValue.add("cabecera");
                String tmp = new String(input);
                documentWrapper docW = new documentWrapper(tmp);
                if (docW.existContainer("Registros")) {
                    AttrContainer atc = docW.getContainer("Registros");
                    Enumeration enm = atc.getItems();
                    while (enm.hasMoreElements()) {
                        ContainerItem ci = (ContainerItem)enm.nextElement();
                        Properties prop = ci.getAttributes();
                        Hashtable<String, Object> reg = new Hashtable<String, Object>();
                        reg.put("nivel", prop.get("nivel"));
                        reg.put("modificaciones", prop.get("modificaciones"));
                        reg.put("correcciones", prop.get("correcciones"));
                        reg.put("estado", prop.get("estado"));
                        retValue.add(reg);
                    }
                }
            } else {
                retValue.add("cabecera");
            }
        }
        catch (Exception e) {
            retValue.add("error");
            e.printStackTrace();
        }
        return retValue;
    }

    public Vector getGlosasLocacionesIATA(String user, String pwd, String codigosIATA) {
        Vector<Object> retValue = new Vector<Object>();
        String[] nmParam = new String[]{"user", "pwd", "codigosIATA"};
        String[] valParam = new String[]{user, pwd, codigosIATA};
        try {
            byte[] input = this.descomprimeDato((byte[])this.invocaServicio("getGlosasIATA", nmParam, valParam));
            if (input.length > 0) {
                retValue.add("cabecera");
                String tmp = new String(input);
                documentWrapper docW = new documentWrapper(tmp);
                if (docW.existContainer("Registros")) {
                    AttrContainer atc = docW.getContainer("Registros");
                    Enumeration enm = atc.getItems();
                    while (enm.hasMoreElements()) {
                        ContainerItem ci = (ContainerItem)enm.nextElement();
                        Properties prop = ci.getAttributes();
                        Hashtable<String, Object> reg = new Hashtable<String, Object>();
                        reg.put("valor", prop.get("valor"));
                        reg.put("descripcion", prop.get("descripcion"));
                        reg.put("nombreciudad", prop.get("nombreciudad"));
                        reg.put("descripcion", prop.get("descripcion"));
                        reg.put("nombreciudad", prop.get("nombreciudad"));
                        reg.put("nombrepais", prop.get("nombrepais"));
                        reg.put("codigopais", prop.get("codigopais"));
                        retValue.add(reg);
                    }
                }
            } else {
                retValue.add("cabecera");
            }
        }
        catch (Exception e) {
            retValue.add("error");
            e.printStackTrace();
        }
        return retValue;
    }

    public Vector getDatosEmisor(String user, String pwd) {
        Vector<Object> retValue = new Vector<Object>();
        String[] nmParam = new String[]{"user", "pwd"};
        String[] valParam = new String[]{user, pwd};
        try {
            byte[] input = this.descomprimeDato((byte[])this.invocaServicio("getInfoEmisor", nmParam, valParam));
            if (input.length > 0) {
                retValue.add("cabecera");
                String tmp = new String(input);
                documentWrapper docW = new documentWrapper(tmp);
                if (docW.existContainer("Registros")) {
                    AttrContainer atc = docW.getContainer("Registros");
                    Enumeration enm = atc.getItems();
                    while (enm.hasMoreElements()) {
                        ContainerItem ci = (ContainerItem)enm.nextElement();
                        Properties prop = ci.getAttributes();
                        Hashtable<String, Object> reg = new Hashtable<String, Object>();
                        reg.put("nombre", prop.get("nombre"));
                        reg.put("nacionalidad", prop.get("nacionalidad"));
                        reg.put("tpId", prop.get("tpId"));
                        reg.put("valorId", prop.get("valorId"));
                        if (prop.get("direccion") != null && !prop.get("direccion").equals("")) {
                            reg.put("direccion", prop.get("direccion"));
                        }
                        reg.put("cdPais", prop.get("cdPais"));
                        retValue.add(reg);
                    }
                }
            } else {
                retValue.add("cabecera");
            }
        }
        catch (Exception e) {
            retValue.add("error");
            e.printStackTrace();
        }
        return retValue;
    }

    private Object invocaServicio(String metodo, String[] nombreParametros, String[] valorParametros) throws Exception, IllegalArgumentException {
        String faultMsg;
        Response response;
        block13: {
            Parameter result = null;
            response = null;
            faultMsg = null;
            System.setProperty("javax.net.ssl.trustStore", String.valueOf(Util.getPATH()) + Util.getSEPARADOR() + "conf" + Util.getSEPARADOR() + "security" + Util.getSEPARADOR() + "cacerts");
            System.setProperty("javax.net.ssl.trustStorePassword", "changeit");
            URL url = new URL(this.strUrl);
            Call call = new Call();
            call.setTargetObjectURI(Util.getUri());
            call.setMethodName(metodo);
            call.setEncodingStyleURI("http://schemas.xmlsoap.org/soap/encoding/");
            SOAPHTTPConnection HTTPTransport = null;
            HTTPTransport = new SOAPHTTPConnection();
            if (this.useProxy) {
                if (this.proxyUserName != null) {
                    HTTPTransport = new SOAPHTTPConnection();
                    HTTPTransport.setProxyUserName(this.proxyUserName);
                    HTTPTransport.setProxyPassword(this.proxyPassword);
                    call.setSOAPTransport((SOAPTransport)HTTPTransport);
                }
                if (this.proxyHost != null) {
                    if (HTTPTransport == null) {
                        HTTPTransport = new SOAPHTTPConnection();
                    }
                    HTTPTransport.setProxyHost(this.proxyHost);
                    if (this.proxyPort != null) {
                        HTTPTransport.setProxyPort(Integer.valueOf(this.proxyPort).intValue());
                    }
                }
            }
            Vector<Parameter> params = new Vector<Parameter>();
            call.setParams(params);
            if (nombreParametros != null) {
                int j = 0;
                while (j < nombreParametros.length) {
                    params.addElement(new Parameter(nombreParametros[j], String.class, (Object)valorParametros[j], null));
                    ++j;
                }
            }
            if ((response = call.invoke(url, "")).generatedFault()) break block13;
            result = response.getReturnValue();
            if (result != null) {
                return result.getValue();
            }
            return null;
        }
        try {
            faultMsg = response.getFault().getFaultString();
            throw new IllegalArgumentException("");
        }
        catch (IllegalArgumentException E) {
            throw new IllegalArgumentException("Error en la respuesta recibida desde el servidor :\n\t" + faultMsg);
        }
        catch (SOAPException ESoap) {
            throw new Exception(String.valueOf(((Object)((Object)ESoap)).getClass().getName()) + "\n\tusando url " + this.strUrl + "\n\t" + ESoap.getMessage() + "\n\tPosiblemente usted no tiene servicio de red en este momento. Int\u00c3\u00a9ntelo m\u00c3\u00a1s tarde");
        }
        catch (Exception E) {
            E.printStackTrace();
            throw new Exception("Error local invocando servicio usando " + this.strUrl + ":\n\t" + E.getMessage());
        }
    }

    public void setProxyHost(String proxyHost) throws Exception {
        if (!this.useProxy) {
            throw new Exception("El servidor no usa Proxy");
        }
        this.proxyHost = proxyHost;
    }

    public void setProxyPort(String proxyPort) throws Exception {
        if (!this.useProxy) {
            throw new Exception("El servidor no usa Proxy");
        }
        this.proxyPort = proxyPort;
    }

    public void setProxyPassword(String proxyPassword) throws Exception {
        if (!this.useProxy) {
            throw new Exception("El servidor no usa Proxy");
        }
        this.proxyPassword = proxyPassword;
    }

    public void setProxyUserName(String proxyUserName) throws Exception {
        if (!this.useProxy) {
            throw new Exception("El servidor no usa Proxy");
        }
        this.proxyUserName = proxyUserName;
    }
}

