/*
 * Decompiled with CFR 0.152.
 */
package sms.validador;

import ProcesadorDocumentos.XMLHelpers.AttrContainer;
import ProcesadorDocumentos.XMLHelpers.ContainerItem;
import ProcesadorDocumentos.XMLHelpers.documentWrapper;
import bti.schema.Documento;
import bti.schema.DocumentoType;
import bti.schema.ObjectFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Enumeration;
import java.util.Properties;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Validator;
import sms.soap.Start;
import sms.util.Util;

public class BTIv10 {
    private String file;
    private String doc;
    private boolean valid = false;

    public BTIv10(String file, String doc) {
        this.file = file;
        this.doc = doc;
        this.init();
    }

    private void init() {
        try {
            ObjectFactory objFactory = new ObjectFactory();
            Documento documento = objFactory.createDocumento();
            documentWrapper dw = new documentWrapper(new File(this.file));
            this.cargaRoot(documento, dw);
            this.cargaLocomotoras(documento, dw);
            this.cargaLocaciones(documento, dw);
            this.cargaParticipaciones(documento, dw);
            JAXBContext jc = JAXBContext.newInstance("bti.schema");
            Validator v = jc.createValidator();
            this.valid = v.validateRoot(documento);
            if (this.valid) {
                Marshaller m = jc.createMarshaller();
                m.setProperty("jaxb.encoding", "ISO-8859-1");
                m.setProperty("jaxb.formatted.output", Boolean.TRUE);
                if (!new File(String.valueOf(Util.getPATH()) + Util.getSEPARADOR() + "mensajes").exists()) {
                    new File(String.valueOf(Util.getPATH()) + Util.getSEPARADOR() + "mensajes").mkdirs();
                }
                String xml = String.valueOf(Util.getPATH()) + Util.getSEPARADOR() + "mensajes" + Util.getSEPARADOR() + this.doc;
                m.marshal((Object)documento, new FileOutputStream(xml));
            }
        }
        catch (Exception e) {
            if (!this.valid) {
                Start.pe("\t=> [" + this.doc + "]: BTI con Estructura Invalida.-");
                if (e.toString().indexOf(".Abort") != -1) {
                    String msgError = e.toString().substring(e.toString().indexOf(".Abort") + 19, e.toString().length() - 1);
                    Start.pe("\t+ " + msgError);
                } else {
                    Start.pe("\t+ " + e.toString());
                }
                Start.pe("\t=> Moviendo documento [" + this.doc + "] a [SMS_Home\\xml\\invalidos].-\n\n");
            }
            Start.pe("\t=> [" + this.doc + "]: Error manipulando archivo. Posiblemente no tiene permisos necesarios.-\n\n");
            this.valid = false;
        }
    }

    private void cargaRoot(Documento documento, documentWrapper dw) {
        try {
            if (dw.getDocType().equals("BTI")) {
                documento.setTipo(dw.getDocType());
            }
            if (dw.getVersion().equals("1.0")) {
                documento.setVersion(dw.getVersion());
            }
            if (dw.existAttribute("tipo-accion") && !dw.getAttribute("tipo-accion").equals("")) {
                documento.setTipoAccion(dw.getAttribute("tipo-accion").trim());
            }
            if (dw.existAttribute("numero-referencia") && !dw.getAttribute("numero-referencia").equals("")) {
                documento.setNumeroReferencia(dw.getAttribute("numero-referencia").trim());
            }
            if (dw.existAttribute("acta") && !dw.getAttribute("acta").equals("")) {
                documento.setActa(dw.getAttribute("acta").trim());
            }
            if (dw.existAttribute("tren") && !dw.getAttribute("tren").equals("")) {
                documento.setTren(dw.getAttribute("tren").trim());
            }
            if (dw.existAttribute("fecha") && !dw.getAttribute("fecha").equals("")) {
                documento.setFecha(dw.getAttribute("fecha").trim());
            }
            if (dw.existAttribute("total-vagones") && !dw.getAttribute("total-vagones").equals("")) {
                documento.setTotalVagones(dw.getAttribute("total-vagones").trim());
            }
            if (dw.existAttribute("total-bultos") && !dw.getAttribute("total-bultos").equals("")) {
                documento.setTotalBultos(dw.getAttribute("total-bultos").trim());
            }
            if (dw.existAttribute("total-peso-neto") && !dw.getAttribute("total-peso-neto").equals("")) {
                documento.setTotalPesoNeto(dw.getAttribute("total-peso-neto").trim());
            }
            if (dw.existAttribute("total-peso-bruto") && !dw.getAttribute("total-peso-bruto").equals("")) {
                documento.setTotalPesoBruto(dw.getAttribute("total-peso-bruto").trim());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void cargaLocomotoras(Documento documento, documentWrapper dw) {
        ObjectFactory objFactory = new ObjectFactory();
        try {
            if (dw.existContainer("Locomotoras")) {
                DocumentoType.LocomotorasType locomotoras = objFactory.createDocumentoTypeLocomotorasType();
                AttrContainer atc = dw.getContainer("Locomotoras");
                Enumeration enm = atc.getItems();
                while (enm.hasMoreElements()) {
                    ContainerItem ci = (ContainerItem)enm.nextElement();
                    Properties prop = ci.getAttributes();
                    DocumentoType.LocomotorasType.LocomotoraType locomotora = objFactory.createDocumentoTypeLocomotorasTypeLocomotoraType();
                    if (prop.containsKey("id") && !prop.get("id").equals("")) {
                        locomotora.setId(String.valueOf(prop.get("id")).trim());
                    }
                    if (prop.containsKey("maquinista") && !prop.get("maquinista").equals("")) {
                        locomotora.setMaquinista(String.valueOf(prop.get("maquinista")).trim());
                    }
                    if (prop.containsKey("auxiliar") && !prop.get("auxiliar").equals("")) {
                        locomotora.setAuxiliar(String.valueOf(prop.get("auxiliar")).trim());
                    }
                    locomotoras.getLocomotora().add(locomotora);
                }
                documento.setLocomotoras(locomotoras);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void cargaLocaciones(Documento documento, documentWrapper dw) {
        ObjectFactory objFactory = new ObjectFactory();
        try {
            if (dw.existContainer("Locaciones")) {
                DocumentoType.LocacionesType locaciones = objFactory.createDocumentoTypeLocacionesType();
                AttrContainer atc = dw.getContainer("Locaciones");
                Enumeration enm = atc.getItems();
                while (enm.hasMoreElements()) {
                    ContainerItem ci = (ContainerItem)enm.nextElement();
                    Properties prop = ci.getAttributes();
                    DocumentoType.LocacionesType.LocacionType locacion = objFactory.createDocumentoTypeLocacionesTypeLocacionType();
                    if (prop.containsKey("tipo") && !prop.get("tipo").equals("")) {
                        locacion.setTipo(String.valueOf(prop.get("tipo")).trim());
                    }
                    if (prop.containsKey("estacion") && !prop.get("estacion").equals("")) {
                        locacion.setEstacion(String.valueOf(prop.get("estacion")).trim());
                    }
                    if (prop.containsKey("jefe-estacion") && !prop.get("jefe-estacion").equals("")) {
                        locacion.setJefeEstacion(String.valueOf(prop.get("jefe-estacion")).trim());
                    }
                    if (prop.containsKey("carrocero") && !prop.get("carrocero").equals("")) {
                        locacion.setCarrocero(String.valueOf(prop.get("carrocero")).trim());
                    }
                    locaciones.getLocacion().add(locacion);
                }
                documento.setLocaciones(locaciones);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void cargaParticipaciones(Documento documento, documentWrapper dw) {
        ObjectFactory objFactory = new ObjectFactory();
        try {
            if (dw.existContainer("Participaciones")) {
                DocumentoType.ParticipacionesType participaciones = objFactory.createDocumentoTypeParticipacionesType();
                AttrContainer atc = dw.getContainer("Participaciones");
                Enumeration enm = atc.getItems();
                while (enm.hasMoreElements()) {
                    ContainerItem ci = (ContainerItem)enm.nextElement();
                    Properties prop = ci.getAttributes();
                    DocumentoType.ParticipacionesType.ParticipacionType participacion = objFactory.createDocumentoTypeParticipacionesTypeParticipacionType();
                    if (prop.containsKey("remitente") && !prop.get("remitente").equals("")) {
                        participacion.setRemitente(String.valueOf(prop.get("remitente")).trim());
                    }
                    if (prop.containsKey("consignatario") && !prop.get("consignatario").equals("")) {
                        participacion.setConsignatario(String.valueOf(prop.get("consignatario")).trim());
                    }
                    if (prop.containsKey("destino") && !prop.get("destino").equals("")) {
                        participacion.setDestino(String.valueOf(prop.get("destino")).trim());
                    }
                    if (prop.containsKey("producto") && !prop.get("producto").equals("")) {
                        participacion.setProducto(String.valueOf(prop.get("producto")).trim());
                    }
                    if (ci.existContainer("Items")) {
                        DocumentoType.ParticipacionesType.ParticipacionType.ItemsType items = objFactory.createDocumentoTypeParticipacionesTypeParticipacionTypeItemsType();
                        AttrContainer atc2 = ci.getContainer("Items");
                        Enumeration enm2 = atc2.getItems();
                        while (enm2.hasMoreElements()) {
                            ContainerItem ci2 = (ContainerItem)enm2.nextElement();
                            Properties prop2 = ci2.getAttributes();
                            DocumentoType.ParticipacionesType.ParticipacionType.ItemsType.ItemType item = objFactory.createDocumentoTypeParticipacionesTypeParticipacionTypeItemsTypeItemType();
                            if (prop2.containsKey("nro-vagon") && !prop2.get("nro-vagon").equals("")) {
                                item.setNroVagon(String.valueOf(prop2.get("nro-vagon")).trim());
                            }
                            if (prop2.containsKey("cantidad-bultos") && !prop2.get("cantidad-bultos").equals("")) {
                                item.setCantidadBultos(String.valueOf(prop2.get("cantidad-bultos")).trim());
                            }
                            if (prop2.containsKey("peso-neto") && !prop2.get("peso-neto").equals("")) {
                                item.setPesoNeto(String.valueOf(prop2.get("peso-neto")).trim());
                            }
                            if (prop2.containsKey("peso-bruto") && !prop2.get("peso-bruto").equals("")) {
                                item.setPesoBruto(String.valueOf(prop2.get("peso-bruto")).trim());
                            }
                            if (prop2.containsKey("numero-tif") && !prop2.get("numero-tif").equals("")) {
                                item.setNumeroTif(String.valueOf(prop2.get("numero-tif")).trim());
                            }
                            if (prop2.containsKey("observaciones") && !prop2.get("observaciones").equals("")) {
                                item.setObservaciones(String.valueOf(prop2.get("observaciones")).trim());
                            }
                            if (prop2.containsKey("transito") && !prop2.get("transito").equals("")) {
                                item.setTransito(String.valueOf(prop2.get("transito")).trim());
                            }
                            items.getItem().add(item);
                        }
                        participacion.setItems(items);
                    }
                    participaciones.getParticipacion().add(participacion);
                }
                documento.setParticipaciones(participaciones);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isValid() {
        return this.valid;
    }
}

