/*
 * Decompiled with CFR 0.152.
 */
package sms.validador;

import ProcesadorDocumentos.XMLHelpers.AttrContainer;
import ProcesadorDocumentos.XMLHelpers.ContainerItem;
import ProcesadorDocumentos.XMLHelpers.documentWrapper;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Enumeration;
import java.util.Properties;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Validator;
import mftoa.schema.Documento;
import mftoa.schema.DocumentoType;
import mftoa.schema.ObjectFactory;
import sms.soap.Start;
import sms.util.Util;
import sms.validador.AereoANUv20;

public class MFTOAv20 {
    private String file;
    private String doc;
    private boolean valid = false;

    public MFTOAv20(String file, String doc) {
        this.file = file;
        this.doc = doc;
        this.init();
    }

    private void init() {
        try {
            ObjectFactory objFactory = new ObjectFactory();
            Documento documento = objFactory.createDocumento();
            documentWrapper dw = new documentWrapper(new File(this.file));
            if (!dw.getAttribute("tipo-accion").equals("N")) {
                if (dw.getDocType().equals("MFTOA")) {
                    documento.setTipo(dw.getDocType());
                }
                if (dw.getVersion().equals("2.0")) {
                    documento.setVersion(dw.getVersion());
                }
                if (dw.existAttribute("tipo-accion") && !dw.getAttribute("tipo-accion").equals("")) {
                    documento.setTipoAccion(dw.getAttribute("tipo-accion").trim());
                }
                if (dw.existAttribute("numero-referencia") && !dw.getAttribute("numero-referencia").equals("")) {
                    documento.setNumeroReferencia(dw.getAttribute("numero-referencia").trim());
                }
                if (dw.existAttribute("tipo-manifiesto") && !dw.getAttribute("tipo-manifiesto").equals("")) {
                    documento.setTipoManifiesto(dw.getAttribute("tipo-manifiesto").trim());
                }
                if (dw.existAttribute("cond-carga") && !dw.getAttribute("cond-carga").equals("")) {
                    documento.setCondCarga(dw.getAttribute("cond-carga").trim());
                }
                this.cargaOpTransporte(documento, dw);
                this.cargaFechas(documento, dw);
                this.cargaLocaciones(documento, dw);
                this.cargaParticipaciones(documento, dw);
                this.cargaObservaciones(documento, dw);
                JAXBContext jc = JAXBContext.newInstance("mftoa.schema");
                Validator v = jc.createValidator();
                this.valid = v.validateRoot(documento);
                if (this.valid) {
                    Marshaller m = jc.createMarshaller();
                    m.setProperty("jaxb.encoding", "ISO-8859-1");
                    m.setProperty("jaxb.formatted.output", Boolean.TRUE);
                    if (!new File(String.valueOf(Util.getPATH()) + Util.getSEPARADOR() + "mensajes").exists()) {
                        new File(String.valueOf(Util.getPATH()) + Util.getSEPARADOR() + "mensajes").mkdirs();
                    }
                    String xml = String.valueOf(Util.getPATH()) + Util.getSEPARADOR() + "mensajes" + Util.getSEPARADOR() + this.doc;
                    m.marshal((Object)documento, new FileOutputStream(xml));
                    Util.setNuevoTag("itinerary", "itinerario", xml);
                }
            } else {
                this.valid = new AereoANUv20(this.file, this.doc).isValid();
            }
        }
        catch (Exception e) {
            if (!this.valid) {
                Start.pe("\t=> [" + this.doc + "]: MFTOA con Estructura Invalida.-");
                if (e.toString().indexOf(".Abort") != -1) {
                    String msgError = e.toString().substring(e.toString().indexOf(".Abort") + 19, e.toString().length() - 1);
                    Start.pe("\t+ " + msgError);
                } else {
                    Start.pe("\t+ " + e.toString());
                }
                Start.pe("\t=> Moviendo documento [" + this.doc + "] a [SMS_Home\\xml\\invalidos].-\n\n");
            }
            Start.pe("\t=> [" + this.doc + "]: Error manipulando archivo. Posiblemente no tiene permisos necesarios.-\n\n");
            this.valid = false;
        }
    }

    private void cargaOpTransporte(Documento documento, documentWrapper dw) {
        ObjectFactory objFactory = new ObjectFactory();
        try {
            if (dw.existContainer("OpTransporte")) {
                DocumentoType.OpTransporteType OpTransTp = objFactory.createDocumentoTypeOpTransporteType();
                DocumentoType.OpTransporteType.OptransporteType opTransTp = objFactory.createDocumentoTypeOpTransporteTypeOptransporteType();
                DocumentoType.OpTransporteType.OptransporteType.ItinerarioType ItTp = objFactory.createDocumentoTypeOpTransporteTypeOptransporteTypeItinerarioType();
                AttrContainer atc = dw.getContainer("OpTransporte");
                Enumeration enm = atc.getItems();
                ContainerItem ci = (ContainerItem)enm.nextElement();
                Properties prop = ci.getAttributes();
                if (prop.containsKey("registro-nave") && !prop.get("registro-nave").equals("")) {
                    opTransTp.setRegistroNave(String.valueOf(prop.get("registro-nave")).trim());
                }
                if (prop.containsKey("viaje") && !prop.get("viaje").equals("")) {
                    opTransTp.setViaje(String.valueOf(prop.get("viaje")).trim());
                }
                AttrContainer atc2 = ci.getContainer("Itinerario");
                Enumeration enm2 = atc2.getItems();
                while (enm2.hasMoreElements()) {
                    ContainerItem ci2 = (ContainerItem)enm2.nextElement();
                    Properties prop2 = ci2.getAttributes();
                    DocumentoType.OpTransporteType.OptransporteType.ItinerarioType.ItineraryType itTp = objFactory.createDocumentoTypeOpTransporteTypeOptransporteTypeItinerarioTypeItineraryType();
                    if (prop2.containsKey("lugar") && !prop2.get("lugar").equals("")) {
                        itTp.setLugar(String.valueOf(prop2.get("lugar")).trim());
                    }
                    if (prop2.containsKey("secuencia") && !prop2.get("secuencia").equals("")) {
                        itTp.setSecuencia(String.valueOf(prop2.get("secuencia")).trim());
                    }
                    ItTp.getItinerary().add(itTp);
                }
                opTransTp.setItinerario(ItTp);
                OpTransTp.setOptransporte(opTransTp);
                documento.setOpTransporte(OpTransTp);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void cargaFechas(Documento documento, documentWrapper dw) {
        ObjectFactory objFactory = new ObjectFactory();
        try {
            if (dw.existContainer("Fechas")) {
                DocumentoType.FechasType FcTp = objFactory.createDocumentoTypeFechasType();
                AttrContainer atc = dw.getContainer("Fechas");
                Enumeration enm = atc.getItems();
                while (enm.hasMoreElements()) {
                    ContainerItem ci = (ContainerItem)enm.nextElement();
                    Properties prop = ci.getAttributes();
                    DocumentoType.FechasType.FechaType fcTp = objFactory.createDocumentoTypeFechasTypeFechaType();
                    if (prop.containsKey("nombre") && !prop.get("nombre").equals("")) {
                        fcTp.setNombre(String.valueOf(prop.get("nombre")).trim());
                    }
                    if (prop.containsKey("valor") && !prop.get("valor").equals("")) {
                        fcTp.setValor(String.valueOf(prop.get("valor")).trim());
                    }
                    FcTp.getFecha().add(fcTp);
                }
                documento.setFechas(FcTp);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void cargaLocaciones(Documento documento, documentWrapper dw) {
        ObjectFactory objFactory = new ObjectFactory();
        try {
            if (dw.existContainer("Locaciones")) {
                DocumentoType.LocacionesType LocTp = objFactory.createDocumentoTypeLocacionesType();
                AttrContainer atc = dw.getContainer("Locaciones");
                Enumeration enm = atc.getItems();
                while (enm.hasMoreElements()) {
                    ContainerItem ci = (ContainerItem)enm.nextElement();
                    Properties prop = ci.getAttributes();
                    DocumentoType.LocacionesType.LocacionType locTp = objFactory.createDocumentoTypeLocacionesTypeLocacionType();
                    if (prop.containsKey("codigo") && !prop.get("codigo").equals("")) {
                        locTp.setCodigo(String.valueOf(prop.get("codigo")).trim());
                    }
                    if (prop.containsKey("nombre") && !prop.get("nombre").equals("")) {
                        locTp.setNombre(String.valueOf(prop.get("nombre")).trim());
                    }
                    LocTp.getLocacion().add(locTp);
                }
                documento.setLocaciones(LocTp);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void cargaParticipaciones(Documento documento, documentWrapper dw) {
        ObjectFactory objFactory = new ObjectFactory();
        try {
            if (dw.existContainer("Participaciones")) {
                DocumentoType.ParticipacionesType PartTp = objFactory.createDocumentoTypeParticipacionesType();
                AttrContainer atc = dw.getContainer("Participaciones");
                Enumeration enm = atc.getItems();
                while (enm.hasMoreElements()) {
                    ContainerItem ci = (ContainerItem)enm.nextElement();
                    Properties prop = ci.getAttributes();
                    DocumentoType.ParticipacionesType.ParticipacionType partTp = objFactory.createDocumentoTypeParticipacionesTypeParticipacionType();
                    if (prop.containsKey("nombre") && !prop.get("nombre").equals("")) {
                        partTp.setNombre(String.valueOf(prop.get("nombre")).trim());
                    }
                    if (prop.containsKey("valor-id") && !prop.get("valor-id").equals("")) {
                        partTp.setValorId(String.valueOf(prop.get("valor-id")).trim());
                    }
                    if (prop.containsKey("tipo-id") && !prop.get("tipo-id").equals("")) {
                        partTp.setTipoId(String.valueOf(prop.get("tipo-id")).trim());
                    }
                    PartTp.getParticipacion().add(partTp);
                }
                documento.setParticipaciones(PartTp);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void cargaObservaciones(Documento documento, documentWrapper dw) {
        ObjectFactory objFactory = new ObjectFactory();
        try {
            if (dw.existContainer("Observaciones")) {
                DocumentoType.ObservacionesType ObTp = objFactory.createDocumentoTypeObservacionesType();
                AttrContainer atc = dw.getContainer("Observaciones");
                Enumeration enm = atc.getItems();
                while (enm.hasMoreElements()) {
                    ContainerItem ci = (ContainerItem)enm.nextElement();
                    Properties prop = ci.getAttributes();
                    DocumentoType.ObservacionesType.ObservacionType obTp = objFactory.createDocumentoTypeObservacionesTypeObservacionType();
                    if (prop.containsKey("contenido") && !prop.get("contenido").equals("")) {
                        obTp.setContenido(String.valueOf(prop.get("contenido")).trim());
                    }
                    if (prop.containsKey("nombre") && !prop.get("nombre").equals("")) {
                        obTp.setNombre(String.valueOf(prop.get("nombre")).trim());
                    }
                    ObTp.getObservacion().add(obTp);
                }
                documento.setObservaciones(ObTp);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isValid() {
        return this.valid;
    }
}

