/*
 * Decompiled with CFR 0.152.
 */
package maritimo.anulacion.schema.impl.runtime;

import com.sun.xml.bind.validator.Locator;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventLocator;
import javax.xml.bind.helpers.ValidationEventImpl;
import maritimo.anulacion.schema.impl.runtime.SAXUnmarshallerHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ErrorHandlerAdaptor
implements ErrorHandler {
    private final SAXUnmarshallerHandler host;
    private final Locator locator;

    public ErrorHandlerAdaptor(SAXUnmarshallerHandler _host, Locator locator) {
        this.host = _host;
        this.locator = locator;
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        this.propagateEvent(1, exception);
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        this.propagateEvent(0, exception);
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        this.propagateEvent(2, exception);
    }

    private void propagateEvent(int severity, SAXParseException saxException) throws SAXException {
        ValidationEventLocator vel = this.locator.getLocation(saxException);
        ValidationEventImpl ve = new ValidationEventImpl(severity, saxException.getMessage(), vel);
        Exception e = saxException.getException();
        if (e != null) {
            ve.setLinkedException((Throwable)e);
        } else {
            ve.setLinkedException((Throwable)saxException);
        }
        this.host.handleEvent((ValidationEvent)ve, severity != 2);
    }
}

