/*
 * Decompiled with CFR 0.152.
 */
package sms.soap;

import ProcesadorDocumentos.XMLHelpers.AttrContainer;
import ProcesadorDocumentos.XMLHelpers.ContainerItem;
import ProcesadorDocumentos.XMLHelpers.documentWrapper;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.StringTokenizer;
import java.util.Vector;
import sms.soap.CarpetaDoc;
import sms.soap.Config;
import sms.soap.Start;
import sms.soap.TipoDocumento;

public class Documento {
    private File archivoOrigen = null;
    private documentWrapper docXML = null;
    private String codigoServidor;
    private String codigoTipoDocumento;
    private String numeroReferencia;
    private String version;
    private String tipoAccion = null;
    private TipoDocumento tipoDocumento = null;
    private CarpetaDoc enCarpeta = null;
    private static char[] conv = new char[]{'-', '/', '*', '+', '?', ':', '\\', '=', ',', ';', '\'', '\"', '[', ']', '<', '>', '%', '&'};

    public Documento(File archivo, CarpetaDoc enCarpeta) throws Exception {
        this.archivoOrigen = archivo;
        String nombreSinExtension = archivo.getName().substring(0, archivo.getName().length() - 4);
        StringTokenizer stok = new StringTokenizer(nombreSinExtension, "-");
        int i = 0;
        String acciones = "IMANV";
        while (stok.hasMoreTokens()) {
            i = i >= 5 ? 5 : i + 1;
            String t = stok.nextToken();
            switch (i) {
                case 1: {
                    this.codigoServidor = t;
                    break;
                }
                case 2: {
                    this.codigoTipoDocumento = t;
                    break;
                }
                case 3: {
                    this.version = t;
                    break;
                }
                case 4: {
                    if (t != null && t.length() == 1 && acciones.indexOf(t) >= 0) {
                        this.tipoAccion = t;
                        t = stok.hasMoreTokens() ? stok.nextToken() : null;
                    }
                    if (t == null) break;
                    this.numeroReferencia = t;
                }
            }
        }
        this.numeroReferencia = Documento.transformaNombreArchivoANumeroRef(this.numeroReferencia);
        if (i < 4) {
            throw new Exception("\tEl nombre del archivo '" + archivo.getName() + "' esta mal formado");
        }
        Config conf = new Config(Start.sms_home);
        if (conf == null) {
            throw new Exception("\tNo se encuentra el servidor " + this.codigoServidor);
        }
        this.tipoDocumento = conf.getTipoDocumento(this.codigoTipoDocumento, this.version, (ContainerItem)conf.getDoc());
        if (this.tipoDocumento == null) {
            throw new Exception("\tNo se encuentra el tipo de documento " + this.codigoTipoDocumento + " version " + this.version + " en el servidor " + this.codigoServidor);
        }
        this.enCarpeta = enCarpeta;
    }

    public Documento(TipoDocumento tipoDoc, documentWrapper XML) {
        this.tipoDocumento = tipoDoc;
        this.codigoTipoDocumento = tipoDoc.getCodigo();
        this.version = tipoDoc.getVersion();
        String numero = XML.getAttribute("numero-referencia");
        if (numero == null || numero.length() == 0) {
            numero = "[ref]";
        }
        this.numeroReferencia = numero;
        this.docXML = XML;
    }

    public Documento(Config c, documentWrapper XML) {
        this(c.getTipoDocumento(XML.getDocType(), XML.getVersion()), XML);
    }

    public String getFileSrc() {
        return this.archivoOrigen.getName();
    }

    public documentWrapper getDocXML() throws Exception {
        if (this.docXML != null) {
            return this.docXML;
        }
        try {
            if (this.archivoOrigen != null) {
                this.docXML = new documentWrapper(this.archivoOrigen);
            }
        }
        catch (Exception E) {
            throw new Exception("\tEl archivo con el documento XML esta mal formado:\n" + E.getMessage());
        }
        return this.docXML;
    }

    public AttrContainer agregaItemControl(String operacion, String estado) throws Exception {
        AttrContainer cntControl = this.getDocXML().getContainer("Control");
        if (cntControl == null) {
            cntControl = this.getDocXML().addContainer("Control", "item-control");
        }
        ContainerItem itemControl = cntControl.addItem();
        itemControl.setAttribute("fecha-hora-local", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(Calendar.getInstance().getTime()));
        if (operacion != null) {
            itemControl.setAttribute("operacion", operacion);
        }
        if (estado != null) {
            itemControl.setAttribute("estado", estado);
        }
        return itemControl.addContainer("Detalles", "detalle");
    }

    public String getNumeroReferencia() {
        return this.numeroReferencia;
    }

    public static String transformaNombreArchivoANumeroRef(String nombreArchivo) {
        StringBuffer ret = new StringBuffer("");
        int i = 0;
        int p = nombreArchivo.indexOf(".(");
        while (p >= 0) {
            ret.append(nombreArchivo.substring(i, p));
            int p2 = nombreArchivo.indexOf(").", p);
            if (p2 > 0) {
                i = p2 + 2;
                String stCod = nombreArchivo.substring(p + 2, p2);
                try {
                    int cod = Integer.valueOf(stCod);
                    char c = (char)cod;
                    ret.append(c);
                }
                catch (Exception E) {
                    E.printStackTrace();
                    return "NOMBRE DE ARCHIVO INVALIDO";
                }
            }
            p = nombreArchivo.indexOf(".(", i);
        }
        ret.append(nombreArchivo.substring(i));
        return ret.toString();
    }

    public String getNombreArchivo() {
        Vector atributosExtra;
        String accion = null;
        try {
            String nmArchivo = this.getFileSrc();
            int index = nmArchivo.indexOf(String.valueOf(this.getDocXML().getDocType()) + "-" + this.getDocXML().getVersion()) + (String.valueOf(this.getDocXML().getDocType()) + "-" + this.getDocXML().getVersion()).length() + 1;
            String nuevoNumeroReferencia = nmArchivo.substring(index, nmArchivo.lastIndexOf("."));
            if (nuevoNumeroReferencia != null) {
                this.numeroReferencia = nuevoNumeroReferencia;
            }
            if (this.numeroReferencia == null || this.numeroReferencia.length() == 0 || this.numeroReferencia.equals("[ref]")) {
                this.numeroReferencia = "" + this.getTipoDocumento().siguienteNumero();
                this.getDocXML().setAttribute("numero-referencia", this.numeroReferencia);
            }
            if (this.getDocXML().getAttribute("tipo-accion") != null) {
                accion = this.getDocXML().getAttribute("tipo-accion");
            }
            if (accion != null && accion.equals("I")) {
                accion = null;
            }
        }
        catch (Exception E) {
            E.printStackTrace();
        }
        String infoExtra = null;
        if (accion == null && (atributosExtra = this.getTipoDocumento().getAtributosExtra()) != null && atributosExtra.size() > 0) {
            int i = 0;
            while (i < atributosExtra.size()) {
                String nombre = (String)atributosExtra.elementAt(i);
                String valor = null;
                try {
                    valor = this.getDocXML().getAttribute(nombre);
                    if (valor == null) {
                        valor = this.getDocXML().getContainer(nombre).size() + " " + nombre;
                    }
                }
                catch (Exception E) {
                    valor = null;
                }
                if (valor == null) {
                    valor = "{" + nombre + " ?}";
                }
                valor = "(" + valor + ")";
                infoExtra = infoExtra == null ? valor : String.valueOf(infoExtra) + "-" + valor;
                ++i;
            }
        }
        String numRef = Documento.transformaNumeroRefANombreArchivo(this.numeroReferencia);
        accion = null;
        return String.valueOf(this.codigoServidor) + "-" + this.codigoTipoDocumento + "-" + this.version + (accion == null ? "" : "-" + accion) + "-" + numRef + (infoExtra != null && infoExtra.trim().length() > 0 ? "-" + infoExtra : "") + ".xml";
    }

    public static String transformaNumeroRefANombreArchivo(String numeroRef) {
        StringBuffer ret = new StringBuffer("");
        int i = 0;
        while (i < numeroRef.length()) {
            char c = numeroRef.charAt(i);
            boolean convertido = false;
            int j = 0;
            while (j < conv.length) {
                if (c == conv[j]) {
                    convertido = true;
                    String conversion = ".(" + c + ").";
                    ret.append(conversion);
                    break;
                }
                ++j;
            }
            if (!convertido) {
                ret.append(c);
            }
            ++i;
        }
        return ret.toString();
    }

    public boolean esPrimerEnvio() {
        try {
            String tipoAccion = this.getDocXML().getAttribute("tipo-accion");
            return tipoAccion == null || tipoAccion.equals("I");
        }
        catch (Exception E) {
            E.printStackTrace();
            return false;
        }
    }

    public TipoDocumento getTipoDocumento() {
        return this.tipoDocumento;
    }

    public String getVersionTipoDocumento() {
        return this.version;
    }

    public String getCodigoTipoDocumento() {
        return this.codigoTipoDocumento;
    }

    public File getArchivoOrigen() {
        return this.archivoOrigen;
    }

    public void setArchivoOrigen(File a) {
        this.archivoOrigen = a;
    }

    public void setCarpeta(CarpetaDoc enCarpeta) {
        this.enCarpeta = enCarpeta;
    }

    public String getCodigoServidor() {
        return this.codigoServidor;
    }

    public CarpetaDoc getCarpeta() {
        return this.enCarpeta;
    }
}

