/*
 * Decompiled with CFR 0.152.
 */
package sms.soap;

import ProcesadorDocumentos.XMLHelpers.AttrContainer;
import ProcesadorDocumentos.XMLHelpers.ContainerItem;
import ProcesadorDocumentos.XMLHelpers.documentWrapper;
import java.io.File;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import sms.soap.CarpetaDoc;
import sms.soap.Config;
import sms.soap.Documento;
import sms.soap.ServidorSOAP;
import sms.util.Util;
import sms.validador.Validador;

public class Start
extends Thread {
    public ServidorSOAP serverSoap = null;
    private Config conf = null;
    public static int time;
    public static int i;
    public static String sms_home;
    public static boolean use_proxy;
    private static boolean log;

    static {
        i = 0;
        sms_home = null;
        use_proxy = false;
        log = false;
    }

    public Start() {
        try {
            this.conf = new Config(sms_home);
            this.serverSoap = new ServidorSOAP(this.conf.getUrl(), use_proxy);
            int valid = this.isUserValido();
            if (valid == 1) {
                Util.creaEmisorConf(this.getDatosEmisor());
                if (use_proxy && this.conf.getHostProxy() != null && this.conf.getPortProxy() != null) {
                    this.serverSoap.setProxyHost(this.conf.getHostProxy());
                    this.serverSoap.setProxyPort(this.conf.getPortProxy());
                    this.serverSoap.setProxyUserName(this.conf.getUsuarioProxy());
                    this.serverSoap.setProxyPassword(this.conf.getPasswordProxy());
                }
                Util.creaEmisorConf(this.getDatosEmisor());
                try {
                    Start.p("========================================================================");
                    Start.p(" Sistema de Mensajeria por SOAP - SMS");
                    Start.p(" -----------------------------------------");
                    Start.p("  Servidor\t: " + this.conf.getUrl());
                    Start.p("  Usuario\t: " + this.conf.getUsuario());
                    Start.p("  SMS Home\t: " + this.conf.getHome());
                    Start.p("  Tiempo\t: " + time + " minuto(s)");
                    if (use_proxy) {
                        Start.p("  Proxy\t\t: " + this.conf.getHostProxy());
                        Start.p("  Proxy Port\t: " + this.conf.getPortProxy());
                    }
                    Start.p("========================================================================\n");
                    SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy HH:mm");
                    int cont = 0;
                    while (true) {
                        Start.p("[>>>] Envio (" + ++cont + "): " + df.format(new Date()));
                        int i = 0;
                        while (i < 3) {
                            int enviados = this.procesaMensajes();
                            if (enviados <= 0) {
                                Start.p("\n");
                                break;
                            }
                            Start.p("\tEn espera...\n");
                            Util.cleanDir("mensajes");
                            Thread.sleep(15000L);
                            ++i;
                        }
                        Start.p("[<<<] Consulta (" + cont + "): " + df.format(new Date()));
                        this.procesaPendientes();
                        Start.p("------------------------------------------------------------------------");
                        Thread.sleep(time * 60000);
                    }
                }
                catch (Exception E) {
                    System.err.println("Error: " + E.getMessage());
                }
            } else if (valid == 0) {
                Start.p("Usuario o Password invalido");
            } else {
                Start.p("Error en respuesta del Servidor. Posiblemente usted no tiene servicio de red en este momento. Intentelo mas tarde");
            }
        }
        catch (Exception E) {
            System.err.println("Error: " + E.getMessage());
        }
    }

    public int isUserValido() {
        int valid = this.serverSoap.isUserValido(this.conf.getUsuario(), this.conf.getPassword());
        return valid;
    }

    public String isUserAlmacenista() {
        return this.serverSoap.isUserAlmacenista(this.conf.getUsuario(), this.conf.getPassword());
    }

    public Vector getDocsTramitados(String fcDesde, String fcHasta, String tpDoc, String version) {
        Vector retValue = new Vector();
        retValue = this.serverSoap.getDocsTramitados(this.conf.getUsuario(), this.conf.getPassword(), fcDesde, fcHasta, tpDoc, version);
        return retValue;
    }

    public Vector getDocsTramitadosPorEstado(String fcDesde, String fcHasta, String tpDoc, String version, String tpEstado) {
        Vector retValue = new Vector();
        retValue = this.serverSoap.getDocsTramitadosPorEstado(this.conf.getUsuario(), this.conf.getPassword(), fcDesde, fcHasta, tpDoc, version, tpEstado);
        return retValue;
    }

    public Vector getDocsTramitadosAlm(String idAlm, String fcDesde, String fcHasta, String tpDoc, String version) {
        return this.serverSoap.getDocsTramitadosAlm(this.conf.getUsuario(), this.conf.getPassword(), idAlm, fcDesde, fcHasta, tpDoc, version);
    }

    public Vector getDocTramitadoHist(String nroRef, String tpDoc, String version) {
        Vector retValue = new Vector();
        retValue = this.serverSoap.getDocTramitadoHist(this.conf.getUsuario(), this.conf.getPassword(), nroRef, tpDoc, version);
        return retValue;
    }

    public String getDocsAprobados(String idServ) {
        String retValue = "";
        retValue = this.serverSoap.getDocsAprobados(this.conf.getUsuario(), this.conf.getPassword(), idServ);
        return retValue;
    }

    public String getDocsAprobadosxId(String idServ, String idDoc) {
        String retValue = "";
        retValue = this.serverSoap.getDocsAprobadosxId(this.conf.getUsuario(), this.conf.getPassword(), idServ, idDoc);
        return retValue;
    }

    public Vector getDetLogDocsRechazados(String nroRef, String tpDoc) {
        Vector retValue = new Vector();
        retValue = this.serverSoap.getDetLogDocsRechazados(this.conf.getUsuario(), this.conf.getPassword(), nroRef, tpDoc);
        return retValue;
    }

    public Vector getDetLogDocsRechazados(String usuario, String nroRef, String tpDoc) {
        return this.serverSoap.getDetLogDocsRechazados(this.conf.getUsuario(), this.conf.getPassword(), usuario, nroRef, tpDoc);
    }

    public Vector getDatosSoftware(String codSoft, String estado) {
        return this.serverSoap.getDatosSoftware(this.conf.getUsuario(), this.conf.getPassword(), codSoft, estado);
    }

    public Vector getDatosEmisor() {
        return this.serverSoap.getDatosEmisor(this.conf.getUsuario(), this.conf.getPassword());
    }

    private int procesaMensajes() throws Exception {
        int enviados = 0;
        try {
            int i;
            CarpetaDoc mensajes = new CarpetaDoc("mensajes", String.valueOf(this.conf.getHome()) + Util.getSEPARADOR() + "mensajes");
            CarpetaDoc pendientes = new CarpetaDoc("pendientes", String.valueOf(this.conf.getHome()) + Util.getSEPARADOR() + "xml" + Util.getSEPARADOR() + "pendientes");
            CarpetaDoc desconocidos = new CarpetaDoc("desconocidos", String.valueOf(this.conf.getHome()) + Util.getSEPARADOR() + "xml" + Util.getSEPARADOR() + "desconocidos");
            CarpetaDoc duplicados = new CarpetaDoc("duplicados", String.valueOf(this.conf.getHome()) + Util.getSEPARADOR() + "xml" + Util.getSEPARADOR() + "duplicados");
            try {
                Start.p("\tVerificando Desconocidos, por favor espere...");
                Documento[] docs = desconocidos.getDocumentos();
                if (docs != null && docs.length > 0) {
                    i = 0;
                    while (i < docs.length) {
                        mensajes.mueveDocumento(docs[i], true);
                        Start.p("\t" + (i + 1) + ".- Moviendo documento " + docs[i].getFileSrc() + " desde Desconocidos a Mensajes");
                        ++i;
                    }
                } else {
                    Start.p("\tNo se encontraron archivos en " + desconocidos.getPath());
                }
            }
            catch (Exception e) {
                Start.pe("Error moviendo documento desde Desconocidos a Mensajes. La copia de archivos a Mensajes se ha detenido");
            }
            Start.p("\n\tVerificando Mensajes, por favor espere...");
            Documento[] documentos = mensajes.getDocumentos();
            try {
                i = 0;
                while (i < documentos.length) {
                    if (documentos[i] != null) {
                        String nmFile = Util.creaNmArchivo(documentos[i]);
                        if (new File(String.valueOf(this.conf.getHome()) + Util.getSEPARADOR() + "xml" + Util.getSEPARADOR() + "pendientes" + Util.getSEPARADOR() + nmFile).exists() || new File(String.valueOf(this.conf.getHome()) + Util.getSEPARADOR() + "xml" + Util.getSEPARADOR() + "pendientes" + Util.getSEPARADOR() + documentos[i].getFileSrc()).exists()) {
                            Start.p("\tEl documento " + documentos[i].getFileSrc() + " ya ha sido enviado y existe una respuesta pendiente");
                            duplicados.mueveDocumento(documentos[i], true);
                            Start.p("\tMoviendo documento " + documentos[i].getFileSrc() + " desde Mensajes a Duplicados\n");
                        }
                    }
                    ++i;
                }
                documentos = mensajes.getDocumentos();
            }
            catch (Exception e) {
                Start.pe("Error en verificacion de Duplicados: " + e.getMessage());
            }
            try {
                Validador val = new Validador(Util.getPATH(), documentos);
                documentos = val.getValidos();
            }
            catch (Exception E) {
                Start.pe("Error en proceso de validacion: " + E.getMessage());
            }
            if (documentos != null && documentos.length > 0) {
                enviados = documentos.length;
                int j = 0;
                while (j < documentos.length) {
                    if (documentos[j] != null && !documentos[j].getDocXML().toXMLOnlyData().equals("")) {
                        boolean action = false;
                        int nr = j + 1;
                        int k = 0;
                        k = 1;
                        while (k < 5) {
                            try {
                                documentWrapper tmp = documentos[j].getDocXML();
                                tmp.setAttribute("id-sender", "SMS_CL-" + Util.getNivel() + "." + Util.getMod() + "." + Util.getCorr());
                                tmp.setAttribute("user-host-origen", InetAddress.getLocalHost().toString());
                                tmp.saveToFile(new File(String.valueOf(this.conf.getHome()) + Util.getSEPARADOR() + "mensajes" + Util.getSEPARADOR() + documentos[j].getFileSrc()));
                                if (action) {
                                    Start.p("\n\t>>> Intento de reenvio (" + (k - 1) + ") archivo: " + documentos[j].getFileSrc());
                                }
                                action = true;
                                this.serverSoap.enviaDocumento(documentos[j], this.conf.getUsuario(), this.conf.getPassword());
                                Start.p("\t" + nr + ".- Enviando a SNA archivo: " + documentos[j].getFileSrc());
                                documentos[j].agregaItemControl("Enviado al servidor " + this.conf.getNombreServidor(), null);
                                pendientes.mueveDocumento(documentos[j], true);
                                break;
                            }
                            catch (Exception E) {
                                if (action) {
                                    Start.p("\t<<< Error enviando documento: " + documentos[j].getFileSrc() + "\n\t" + E.getMessage());
                                } else {
                                    Start.p("\t<<< Error marcando documento: " + documentos[j].getFileSrc() + "\n\t" + E.getMessage());
                                }
                                ++k;
                            }
                        }
                        if (k == 5) {
                            desconocidos.mueveDocumento(documentos[j], true);
                            Start.p("\n\t>>> Moviendo documento " + documentos[j].getFileSrc() + " desde Mensajes a Desconocidos");
                        }
                    }
                    ++j;
                }
            } else {
                Start.p("\tNo se encontraron archivos en " + mensajes.getPath());
            }
        }
        catch (Exception E) {
            Start.pe("Error en m\u00c3\u00a9todo procesaEntrada: " + E.getMessage());
        }
        return enviados;
    }

    private void procesaPendientes() throws Exception {
        Start.p("\tVerificando Pendientes, por favor espere...");
        CarpetaDoc pendientes = new CarpetaDoc("pendientes", String.valueOf(this.conf.getHome()) + Util.getSEPARADOR() + "xml" + Util.getSEPARADOR() + "pendientes");
        CarpetaDoc terminados = new CarpetaDoc("terminados", String.valueOf(this.conf.getHome()) + Util.getSEPARADOR() + "xml" + Util.getSEPARADOR() + "terminados");
        CarpetaDoc rechazados = new CarpetaDoc("rechazados", String.valueOf(this.conf.getHome()) + Util.getSEPARADOR() + "xml" + Util.getSEPARADOR() + "rechazados");
        CarpetaDoc desconocidos = new CarpetaDoc("desconocidos", String.valueOf(this.conf.getHome()) + Util.getSEPARADOR() + "xml" + Util.getSEPARADOR() + "desconocidos");
        CarpetaDoc enviados = new CarpetaDoc("enviados", String.valueOf(this.conf.getHome()) + Util.getSEPARADOR() + "xml" + Util.getSEPARADOR() + "enviados");
        Vector<Documento> tmp = new Vector<Documento>();
        int nro = 0;
        Documento[] documentos = pendientes.getDocumentos();
        int i = 0;
        while (i < documentos.length) {
            try {
                if (documentos[i].getDocXML().getDocType().equals("GR")) {
                    Start.p("\t" + ++nro + ".- Moviendo documento " + documentos[i].getFileSrc() + " desde Pendientes hacia Enviados");
                    enviados.mueveDocumento(documentos[i]);
                } else {
                    tmp.add(documentos[i]);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
        documentos = new Documento[tmp.size()];
        int h = 0;
        while (h < tmp.size()) {
            documentos[h] = (Documento)tmp.get(h);
            ++h;
        }
        if (documentos != null && documentos.length > 0) {
            int j = 0;
            while (j < documentos.length) {
                if (documentos[j] != null) {
                    ++nro;
                    try {
                        documentWrapper respuesta = this.serverSoap.consultaDocumento(documentos[j], this.conf.getUsuario(), this.conf.getPassword());
                        String estado = respuesta.getAttribute("Estado");
                        if (estado == null) {
                            Start.p("\tExiste un error consultando estado del documento " + documentos[j].getFileSrc() + ": No hay un estado en la respuesta: " + respuesta);
                        } else if (estado.equals("Error")) {
                            String mensaje = respuesta.getAttribute("Mensaje");
                            Start.p("\tEl servidor " + this.conf.getUrl() + " reporta un error consultando por el estado del documento " + documentos[j].getFileSrc() + ": " + mensaje);
                        } else if (estado.equals("No Procesado")) {
                            Start.p("\t" + nro + ".- El documento " + documentos[j].getFileSrc() + " aun no ha sido procesado por el servidor");
                        } else if (estado.equals("Desconocido")) {
                            Start.p("\t" + nro + ".- Moviendo documento " + documentos[j].getFileSrc() + " desde Pendientes hacia Desconocidos");
                            documentos[j].agregaItemControl("Validacion Documento Enviado", "Documento Desconocido");
                            desconocidos.mueveDocumento(documentos[j], true);
                        } else {
                            AttrContainer cntDetalles = documentos[j].agregaItemControl("Respuesta recibida desde el servidor " + this.conf.getUrl(), estado);
                            AttrContainer cntDetallesRecibidos = respuesta.getContainer("Detalles");
                            AttrContainer cntInstrucciones = null;
                            ContainerItem instruccion = null;
                            if (cntDetallesRecibidos != null) {
                                int k = 0;
                                while (k < cntDetallesRecibidos.size()) {
                                    ContainerItem detalleRecibido = cntDetallesRecibidos.getItem(k);
                                    String tipoDetalle = detalleRecibido.getAttribute("tipo");
                                    String valorDetalle = detalleRecibido.getAttribute("valor");
                                    ContainerItem nuevoDetalle = cntDetalles.addItem();
                                    nuevoDetalle.setAttribute("tipo", tipoDetalle);
                                    nuevoDetalle.setAttribute("valor", valorDetalle);
                                    if (tipoDetalle.equals("Instruccion")) {
                                        int idx = valorDetalle.indexOf(":");
                                        if (idx > 0) {
                                            if (instruccion == null) {
                                                documentWrapper docInstrucciones = new documentWrapper("instruccion", "1.0");
                                                cntInstrucciones = docInstrucciones.addContainer("instrucciones", "instruccion");
                                                instruccion = cntInstrucciones.addItem();
                                            }
                                            instruccion.setAttribute(valorDetalle.substring(0, idx), valorDetalle.substring(idx + 1));
                                        }
                                    } else {
                                        nuevoDetalle.setAttribute("tipo", tipoDetalle);
                                        nuevoDetalle.setAttribute("valor", valorDetalle);
                                    }
                                    ++k;
                                }
                            } else {
                                Start.pe("\tNo hay detalles en la respuesta:\n" + respuesta);
                            }
                            if (estado.equals("Aprobado")) {
                                Long idServidor;
                                String corr = respuesta.getAttribute("correlativo-parcial");
                                if (corr != null && !corr.equals("")) {
                                    documentos[j].getDocXML().setAttribute("correlativo-parcial", corr);
                                }
                                if ((idServidor = respuesta.getLongAttribute("id-documento-servidor")) != null) {
                                    documentos[j].getDocXML().activateVersionning();
                                    documentos[j].getDocXML().setLongAttribute("id-documento-servidor", idServidor);
                                    if (instruccion != null) {
                                        instruccion.setLongAttribute("id-documento", idServidor);
                                    }
                                }
                                Start.p("\t" + nro + ".- Moviendo documento " + documentos[j].getFileSrc() + " desde Pendientes a Terminados");
                                this.procesaInstrucciones(this.conf, documentos[j], cntInstrucciones, "Confirmaci\u00c3\u00b3n de recepci\u00c3\u00b3n del documento " + documentos[j], documentos[j].getCarpeta());
                                terminados.mueveDocumento(documentos[j]);
                                this.grabaRespuesta(this.conf, respuesta, documentos[j]);
                            } else {
                                Start.p("\t" + nro + ".- Moviendo documento " + documentos[j].getFileSrc() + " desde Pendientes a Rechazados");
                                rechazados.mueveDocumento(documentos[j]);
                                this.grabaRespuesta(this.conf, respuesta, documentos[j]);
                            }
                        }
                    }
                    catch (Exception E) {
                        Start.pe("\tError en m\u00c3\u00a9todo procesaPendientes :" + E.getMessage());
                    }
                }
                ++j;
            }
        } else {
            Start.p("\tNo se encontraron archivos en " + pendientes.getPath());
        }
    }

    private boolean procesaInstrucciones(Config conf, Documento documento, AttrContainer cntInstrucciones, String descNotificacion, CarpetaDoc enCarpeta) throws Exception {
        if (cntInstrucciones != null && cntInstrucciones.size() > 0) {
            int i = 0;
            while (i < cntInstrucciones.size()) {
                ContainerItem instruccion = cntInstrucciones.getItem(i);
                Long idDocumento = instruccion.getLongAttribute("id-documento");
                if (idDocumento == null) {
                    idDocumento = instruccion.getLongAttribute("id-documento-servidor");
                }
                String tipoInstruccion = instruccion.getAttribute("tipo");
                boolean puedeAplicar = true;
                if (!(tipoInstruccion.equals("jscript") || tipoInstruccion.equals("cambia-atributo") || tipoInstruccion.equals("bajar-documento") || tipoInstruccion.equals("bajar-nuevo-documento"))) {
                    puedeAplicar = false;
                }
                if (puedeAplicar) {
                    if (documento != null) {
                        documento.getDocXML().activateVersionning();
                    }
                    String NombreArchivo = documento.getNombreArchivo();
                    int sepM = NombreArchivo.lastIndexOf("-M-", NombreArchivo.length());
                    int sepA = NombreArchivo.lastIndexOf("-A-", NombreArchivo.length());
                    NombreArchivo = documento.getNombreArchivo();
                    this.procesaInstruccion(conf, instruccion, documento, tipoInstruccion, descNotificacion);
                    NombreArchivo = documento.getNombreArchivo();
                    if (sepM > 0) {
                        documento.getDocXML().setAttribute("tipo-accion", "M");
                    }
                    if (sepA > 0) {
                        documento.getDocXML().setAttribute("tipo-accion", "A");
                    }
                    if (documento != null) {
                        documento.getDocXML().saveToFile(documento.getArchivoOrigen());
                        new CarpetaDoc("terminados", String.valueOf(conf.getHome()) + Util.getSEPARADOR() + "xml" + Util.getSEPARADOR() + "terminados");
                    }
                }
                ++i;
            }
        }
        return false;
    }

    private void procesaInstruccion(Config conf, ContainerItem instruccion, Documento documento, String tipoInstruccion, String descNotificacion) throws Exception {
        if (tipoInstruccion.equals("bajar-documento")) {
            try {
                Long idDocumentoServidor = documento.getDocXML().getLongAttribute("id-documento-servidor");
                documentWrapper nuevoDoc = this.serverSoap.getXMLDocumento(conf.getUsuario(), conf.getPassword(), documento);
                documento.getDocXML().setXMLOnlyData(nuevoDoc);
                if (documento.getDocXML().getLongAttribute("id-documento-servidor") == null && idDocumentoServidor != null) {
                    documento.getDocXML().setLongAttribute("id-documento-servidor", idDocumentoServidor);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
    }

    private void grabaRespuesta(Config conf, documentWrapper respuesta, Documento documento) {
        File dir = new File(String.valueOf(conf.getHome()) + Util.getSEPARADOR() + "xml" + Util.getSEPARADOR() + "respuestas");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        try {
            int i = 0;
            File f = null;
            while ((f = new File(String.valueOf(conf.getHome()) + Util.getSEPARADOR() + "xml" + Util.getSEPARADOR() + "respuestas" + Util.getSEPARADOR() + "respuesta-" + ++i + "-" + documento.getNombreArchivo())).exists()) {
            }
            respuesta.saveToFile(f);
        }
        catch (Exception E) {
            E.printStackTrace();
        }
    }

    public static void p(String s) {
        System.out.println(s);
        if (log) {
            Util.creaLog(s);
        }
    }

    public static void pe(String s) {
        System.err.println(s);
        if (log) {
            Util.creaLog(s);
        }
    }

    public static void main(String[] args) {
        if (new File(String.valueOf(Util.getPATH()) + Util.getSEPARADOR() + "conf" + Util.getSEPARADOR() + "privados.xml").exists()) {
            try {
                File file = new File(String.valueOf(Util.getPATH()) + Util.getSEPARADOR() + "conf" + Util.getSEPARADOR() + "privados.xml");
                documentWrapper docW = new documentWrapper(file);
                boolean loop = false;
                if (docW.existAttribute("use-proxy") && docW.getAttribute("use-proxy").equals("true")) {
                    use_proxy = true;
                }
                if (docW.existAttribute("sms-home") && !docW.getAttribute("sms-home").equals("SMS_HOME") && !docW.getAttribute("sms-home").equals("")) {
                    sms_home = docW.getAttribute("sms-home");
                } else {
                    Start.p("Debe ingresar sms-home");
                    loop = true;
                }
                if (docW.existAttribute("time")) {
                    try {
                        time = Integer.parseInt(docW.getAttribute("time"));
                    }
                    catch (Exception e) {
                        time = 1;
                    }
                } else {
                    time = 1;
                }
                if (docW.existAttribute("log") && docW.getAttribute("log").equals("true")) {
                    log = true;
                }
                if (!loop) {
                    new Start();
                }
            }
            catch (Exception e) {
                Start.p("Se ha detectado un error al iniciar SMS. Intentelo mas tarde");
            }
        } else {
            Start.p("Estimado usuario, debe editar el archivo SMS_HOME/conf/privados.xml para iniciar SMS");
        }
    }
}

