/*
 * Decompiled with CFR 0.152.
 */
package sms.validador;

import ProcesadorDocumentos.XMLHelpers.AttrContainer;
import ProcesadorDocumentos.XMLHelpers.ContainerItem;
import ProcesadorDocumentos.XMLHelpers.documentWrapper;
import bl.schema.Documento;
import bl.schema.DocumentoType;
import bl.schema.ObjectFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Enumeration;
import java.util.Properties;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Validator;
import sms.soap.Start;
import sms.util.Util;
import sms.validador.MaritimoANUv10;

public class BLv10 {
    private String file;
    private String doc;
    private boolean valid = false;

    public BLv10(String file, String doc) {
        this.file = file;
        this.doc = doc;
        this.init();
    }

    private void init() {
        try {
            ObjectFactory objFactory = new ObjectFactory();
            Documento documento = objFactory.createDocumento();
            documentWrapper dw = new documentWrapper(new File(this.file));
            if (!dw.getAttribute("tipo-accion").equals("N")) {
                if (dw.getDocType().equals("BL")) {
                    documento.setTipo(dw.getDocType());
                }
                if (dw.getVersion().equals("1.0")) {
                    documento.setVersion(dw.getVersion());
                }
                if (dw.existAttribute("tipo-accion") && !dw.getAttribute("tipo-accion").equals("")) {
                    documento.setTipoAccion(dw.getAttribute("tipo-accion").trim());
                }
                if (dw.existAttribute("numero-referencia") && !dw.getAttribute("numero-referencia").equals("")) {
                    documento.setNumeroReferencia(dw.getAttribute("numero-referencia").trim());
                }
                if (dw.existAttribute("fecha-recepcion-bl") && !dw.getAttribute("fecha-recepcion-bl").equals("")) {
                    documento.setFechaRecepcionBl(dw.getAttribute("fecha-recepcion-bl").trim());
                }
                if (dw.existAttribute("service") && !dw.getAttribute("service").equals("")) {
                    documento.setService(dw.getAttribute("service").trim());
                }
                if (dw.existAttribute("tipo-servicio") && !dw.getAttribute("tipo-servicio").equals("")) {
                    documento.setTipoServicio(dw.getAttribute("tipo-servicio").trim());
                }
                if (dw.existAttribute("cond-transporte") && !dw.getAttribute("cond-transporte").equals("")) {
                    documento.setCondTransporte(dw.getAttribute("cond-transporte").trim());
                }
                if (dw.existAttribute("total-bultos") && !dw.getAttribute("total-bultos").equals("")) {
                    documento.setTotalBultos(dw.getAttribute("total-bultos").trim());
                }
                if (dw.existAttribute("total-peso") && !dw.getAttribute("total-peso").equals("")) {
                    documento.setTotalPeso(dw.getAttribute("total-peso").trim());
                }
                if (dw.existAttribute("unidad-peso") && !dw.getAttribute("unidad-peso").equals("")) {
                    documento.setUnidadPeso(dw.getAttribute("unidad-peso").trim());
                }
                if (dw.existAttribute("total-volumen") && !dw.getAttribute("total-volumen").equals("")) {
                    documento.setTotalVolumen(dw.getAttribute("total-volumen").trim());
                }
                if (dw.existAttribute("unidad-volumen") && !dw.getAttribute("unidad-volumen").equals("")) {
                    documento.setUnidadVolumen(dw.getAttribute("unidad-volumen").trim());
                }
                if (dw.existAttribute("total-item") && !dw.getAttribute("total-item").equals("")) {
                    documento.setTotalItem(dw.getAttribute("total-item").trim());
                }
                this.cargaOpTransporte(documento, dw);
                this.cargaFlete(documento, dw);
                this.cargaFechas(documento, dw);
                this.cargaLocaciones(documento, dw);
                this.cargaParticipantes(documento, dw);
                this.cargaTransbordos(documento, dw);
                this.cargaItems(documento, dw);
                this.cargaReferencias(documento, dw);
                this.cargaObservaciones(documento, dw);
                JAXBContext jc = JAXBContext.newInstance("bl.schema");
                Validator v = jc.createValidator();
                this.valid = v.validateRoot(documento);
                if (this.valid) {
                    Marshaller m = jc.createMarshaller();
                    m.setProperty("jaxb.encoding", "ISO-8859-1");
                    m.setProperty("jaxb.formatted.output", Boolean.TRUE);
                    if (!new File(String.valueOf(Util.getPATH()) + Util.getSEPARADOR() + "mensajes").exists()) {
                        new File(String.valueOf(Util.getPATH()) + Util.getSEPARADOR() + "mensajes").mkdirs();
                    }
                    String xml = String.valueOf(Util.getPATH()) + Util.getSEPARADOR() + "mensajes" + Util.getSEPARADOR() + this.doc;
                    m.marshal((Object)documento, new FileOutputStream(xml));
                }
            } else {
                this.valid = new MaritimoANUv10(this.file, this.doc).isValid();
            }
        }
        catch (Exception e) {
            if (!this.valid) {
                Start.pe("\t=> [" + this.doc + "]: BL con Estructura Invalida.-");
                if (e.toString().indexOf(".Abort") != -1) {
                    String msgError = e.toString().substring(e.toString().indexOf(".Abort") + 19, e.toString().length() - 1);
                    Start.pe("\t+ " + msgError);
                } else {
                    Start.pe("\t+ " + e.toString());
                }
                Start.pe("\t=> Moviendo documento [" + this.doc + "] a [SMS_Home\\xml\\invalidos].-\n\n");
            }
            Start.pe("\t=> [" + this.doc + "]: Error manipulando archivo. Posiblemente no tiene permisos necesarios.-\n\n");
            this.valid = false;
        }
    }

    private void cargaOpTransporte(Documento documento, documentWrapper dw) {
        ObjectFactory objFactory = new ObjectFactory();
        try {
            if (dw.existContainer("OpTransporte")) {
                DocumentoType.OpTransporteType OpTrTp = objFactory.createDocumentoTypeOpTransporteType();
                DocumentoType.OpTransporteType.OptransporteType opTrTp = objFactory.createDocumentoTypeOpTransporteTypeOptransporteType();
                AttrContainer atc = dw.getContainer("OpTransporte");
                Enumeration enm = atc.getItems();
                ContainerItem ci = (ContainerItem)enm.nextElement();
                Properties prop = ci.getAttributes();
                if (prop.containsKey("nombre-nave") && !prop.get("nombre-nave").equals("")) {
                    opTrTp.setNombreNave(String.valueOf(prop.get("nombre-nave")).trim());
                }
                if (prop.containsKey("sentido-operacion") && !prop.get("sentido-operacion").equals("")) {
                    opTrTp.setSentidoOperacion(String.valueOf(prop.get("sentido-operacion")).trim());
                }
                OpTrTp.setOptransporte(opTrTp);
                documento.setOpTransporte(OpTrTp);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void cargaFlete(Documento documento, documentWrapper dw) {
        ObjectFactory objFactory = new ObjectFactory();
        try {
            if (dw.existContainer("Flete")) {
                DocumentoType.FleteType flete = objFactory.createDocumentoTypeFleteType();
                DocumentoType.FleteType.FormaPagoFleteType fpFlete = objFactory.createDocumentoTypeFleteTypeFormaPagoFleteType();
                AttrContainer atc = dw.getContainer("Flete");
                Enumeration enm = atc.getItems();
                ContainerItem ci = (ContainerItem)enm.nextElement();
                Properties prop = ci.getAttributes();
                if (prop.containsKey("tipo") && !prop.get("tipo").equals("")) {
                    fpFlete.setTipo(String.valueOf(prop.get("tipo")).trim());
                }
                if (prop.containsKey("descripcion") && !prop.get("descripcion").equals("")) {
                    fpFlete.setDescripcion(String.valueOf(prop.get("descripcion")).trim());
                }
                flete.setFormaPagoFlete(fpFlete);
                documento.setFlete(flete);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void cargaFechas(Documento documento, documentWrapper dw) {
        ObjectFactory objFactory = new ObjectFactory();
        try {
            if (dw.existContainer("Fechas")) {
                DocumentoType.FechasType FcTp = objFactory.createDocumentoTypeFechasType();
                AttrContainer atc = dw.getContainer("Fechas");
                Enumeration enm = atc.getItems();
                while (enm.hasMoreElements()) {
                    ContainerItem ci = (ContainerItem)enm.nextElement();
                    Properties prop = ci.getAttributes();
                    DocumentoType.FechasType.FechaType fcTp = objFactory.createDocumentoTypeFechasTypeFechaType();
                    if (prop.containsKey("nombre") && !prop.get("nombre").equals("")) {
                        fcTp.setNombre(String.valueOf(prop.get("nombre")).trim());
                    }
                    if (prop.containsKey("valor") && !prop.get("valor").equals("")) {
                        fcTp.setValor(String.valueOf(prop.get("valor")).trim());
                    }
                    FcTp.getFecha().add(fcTp);
                }
                documento.setFechas(FcTp);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void cargaLocaciones(Documento documento, documentWrapper dw) {
        ObjectFactory objFactory = new ObjectFactory();
        try {
            if (dw.existContainer("Locaciones")) {
                DocumentoType.LocacionesType LocTp = objFactory.createDocumentoTypeLocacionesType();
                AttrContainer atc = dw.getContainer("Locaciones");
                Enumeration enm = atc.getItems();
                while (enm.hasMoreElements()) {
                    ContainerItem ci = (ContainerItem)enm.nextElement();
                    Properties prop = ci.getAttributes();
                    DocumentoType.LocacionesType.LocacionType locTp = objFactory.createDocumentoTypeLocacionesTypeLocacionType();
                    if (prop.containsKey("nombre") && !prop.get("nombre").equals("")) {
                        locTp.setNombre(String.valueOf(prop.get("nombre")).trim());
                    }
                    if (prop.containsKey("codigo") && !prop.get("codigo").equals("")) {
                        locTp.setCodigo(String.valueOf(prop.get("codigo")).trim());
                    }
                    if (prop.containsKey("descripcion") && !prop.get("descripcion").equals("")) {
                        locTp.setDescripcion(String.valueOf(prop.get("descripcion")).trim());
                    }
                    LocTp.getLocacion().add(locTp);
                }
                documento.setLocaciones(LocTp);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void cargaParticipantes(Documento documento, documentWrapper dw) {
        ObjectFactory objFactory = new ObjectFactory();
        try {
            if (dw.existContainer("Participaciones")) {
                DocumentoType.ParticipacionesType PartTp = objFactory.createDocumentoTypeParticipacionesType();
                AttrContainer atc = dw.getContainer("Participaciones");
                Enumeration enm = atc.getItems();
                while (enm.hasMoreElements()) {
                    ContainerItem ci = (ContainerItem)enm.nextElement();
                    Properties prop = ci.getAttributes();
                    DocumentoType.ParticipacionesType.ParticipacionType partTp = objFactory.createDocumentoTypeParticipacionesTypeParticipacionType();
                    if (prop.containsKey("nacion-id") && !prop.get("nacion-id").equals("")) {
                        partTp.setNacionId(String.valueOf(prop.get("nacion-id")).trim());
                    }
                    if (prop.containsKey("nombre") && !prop.get("nombre").equals("")) {
                        partTp.setNombre(String.valueOf(prop.get("nombre")).trim());
                    }
                    if (prop.containsKey("nombres") && !prop.get("nombres").equals("")) {
                        partTp.setNombres(String.valueOf(prop.get("nombres")).trim());
                    }
                    if (prop.containsKey("tipo-id") && !prop.get("tipo-id").equals("")) {
                        partTp.setTipoId(String.valueOf(prop.get("tipo-id")).trim());
                    }
                    if (prop.containsKey("valor-id") && !prop.get("valor-id").equals("")) {
                        partTp.setValorId(String.valueOf(prop.get("valor-id")).trim());
                    }
                    if (prop.containsKey("codigo-almacen") && !prop.get("codigo-almacen").equals("")) {
                        partTp.setCodigoAlmacen(String.valueOf(prop.get("codigo-almacen")).trim());
                    }
                    if (prop.containsKey("direccion") && !prop.get("direccion").equals("")) {
                        partTp.setDireccion(String.valueOf(prop.get("direccion")).trim());
                    }
                    if (prop.containsKey("comuna") && !prop.get("comuna").equals("")) {
                        partTp.setComuna(String.valueOf(prop.get("comuna")).trim());
                    }
                    if (prop.containsKey("correo-electronico") && !prop.get("correo-electronico").equals("")) {
                        partTp.setCorreoElectronico(String.valueOf(prop.get("correo-electronico")).trim());
                    }
                    if (prop.containsKey("telefono") && !prop.get("telefono").equals("")) {
                        partTp.setTelefono(String.valueOf(prop.get("telefono")).trim());
                    }
                    PartTp.getParticipacion().add(partTp);
                }
                documento.setParticipaciones(PartTp);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void cargaTransbordos(Documento documento, documentWrapper dw) {
        ObjectFactory objFactory = new ObjectFactory();
        try {
            if (dw.existContainer("Transbordos")) {
                DocumentoType.TransbordosType transbordos = objFactory.createDocumentoTypeTransbordosType();
                AttrContainer atc = dw.getContainer("Transbordos");
                Enumeration enm = atc.getItems();
                while (enm.hasMoreElements()) {
                    ContainerItem ci = (ContainerItem)enm.nextElement();
                    Properties prop = ci.getAttributes();
                    DocumentoType.TransbordosType.TransbordoType transbordo = objFactory.createDocumentoTypeTransbordosTypeTransbordoType();
                    if (prop.containsKey("cod-lugar") && !prop.get("cod-lugar").equals("")) {
                        transbordo.setCodLugar(String.valueOf(prop.get("cod-lugar")).trim());
                    }
                    if (prop.containsKey("descripcion-lugar") && !prop.get("descripcion-lugar").equals("")) {
                        transbordo.setDescripcionLugar(String.valueOf(prop.get("descripcion-lugar")).trim());
                    }
                    if (prop.containsKey("fecha-arribo") && !prop.get("fecha-arribo").equals("")) {
                        transbordo.setFechaArribo(String.valueOf(prop.get("fecha-arribo")).trim());
                    }
                    transbordos.getTransbordo().add(transbordo);
                }
                documento.setTransbordos(transbordos);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void cargaItems(Documento documento, documentWrapper dw) {
        ObjectFactory objFactory = new ObjectFactory();
        try {
            if (dw.existContainer("Items")) {
                DocumentoType.ItemsType items = objFactory.createDocumentoTypeItemsType();
                AttrContainer atc = dw.getContainer("Items");
                Enumeration enm = atc.getItems();
                while (enm.hasMoreElements()) {
                    ContainerItem ci = (ContainerItem)enm.nextElement();
                    Properties prop = ci.getAttributes();
                    DocumentoType.ItemsType.ItemType item = objFactory.createDocumentoTypeItemsTypeItemType();
                    if (prop.containsKey("cantidad") && !prop.get("cantidad").equals("")) {
                        item.setCantidad(String.valueOf(prop.get("cantidad")).trim());
                    }
                    if (prop.containsKey("carga-cnt") && !prop.get("carga-cnt").equals("")) {
                        item.setCargaCnt(String.valueOf(prop.get("carga-cnt")).trim());
                    }
                    if (prop.containsKey("carga-peligrosa") && !prop.get("carga-peligrosa").equals("")) {
                        item.setCargaPeligrosa(String.valueOf(prop.get("carga-peligrosa")).trim());
                    }
                    if (ci.existContainer("Contenedores")) {
                        item.setContenedores(this.cargaContenedores(ci));
                    }
                    if (prop.containsKey("descripcion") && !prop.get("descripcion").equals("")) {
                        item.setDescripcion(String.valueOf(prop.get("descripcion")).trim());
                    }
                    if (ci.existContainer("Equipos")) {
                        item.setEquipos(this.cargaEquipos(ci));
                    }
                    if (ci.existContainer("ItemsIMO")) {
                        item.setItemsIMO(this.cargaItemsIMO(ci));
                    }
                    if (prop.containsKey("marcas") && !prop.get("marcas").equals("")) {
                        item.setMarcas(String.valueOf(prop.get("marcas")).trim());
                    }
                    if (prop.containsKey("numero-item") && !prop.get("numero-item").equals("")) {
                        item.setNumeroItem(String.valueOf(prop.get("numero-item")).trim());
                    }
                    if (prop.containsKey("observaciones") && !prop.get("observaciones").equals("")) {
                        item.setObservaciones(String.valueOf(prop.get("observaciones")).trim());
                    }
                    if (prop.containsKey("peso-bruto") && !prop.get("peso-bruto").equals("")) {
                        item.setPesoBruto(String.valueOf(prop.get("peso-bruto")).trim());
                    }
                    if (prop.containsKey("tipo-bulto") && !prop.get("tipo-bulto").equals("")) {
                        item.setTipoBulto(String.valueOf(prop.get("tipo-bulto")).trim());
                    }
                    if (prop.containsKey("unidad-peso") && !prop.get("unidad-peso").equals("")) {
                        item.setUnidadPeso(String.valueOf(prop.get("unidad-peso")).trim());
                    }
                    if (prop.containsKey("unidad-volumen") && !prop.get("unidad-volumen").equals("")) {
                        item.setUnidadVolumen(String.valueOf(prop.get("unidad-volumen")).trim());
                    }
                    if (ci.existContainer("Vehiculos")) {
                        item.setVehiculos(this.cargaVehiculos(ci));
                    }
                    if (prop.containsKey("volumen") && !prop.get("volumen").equals("")) {
                        item.setVolumen(String.valueOf(prop.get("volumen")).trim());
                    }
                    items.getItem().add(item);
                }
                documento.setItems(items);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private DocumentoType.ItemsType.ItemType.ItemsIMOType cargaItemsIMO(ContainerItem ci) {
        ObjectFactory objFactory = new ObjectFactory();
        try {
            DocumentoType.ItemsType.ItemType.ItemsIMOType items = objFactory.createDocumentoTypeItemsTypeItemTypeItemsIMOType();
            AttrContainer atc = ci.getContainer("ItemsIMO");
            Enumeration enm = atc.getItems();
            while (enm.hasMoreElements()) {
                ContainerItem cont = (ContainerItem)enm.nextElement();
                Properties prop = cont.getAttributes();
                DocumentoType.ItemsType.ItemType.ItemsIMOType.ItemimoType item = objFactory.createDocumentoTypeItemsTypeItemTypeItemsIMOTypeItemimoType();
                if (prop.containsKey("clase-imo") && !prop.get("clase-imo").equals("")) {
                    item.setClaseImo(String.valueOf(prop.get("clase-imo")).trim());
                }
                if (prop.containsKey("numero-imo") && !prop.get("numero-imo").equals("")) {
                    item.setNumeroImo(String.valueOf(prop.get("numero-imo")).trim());
                }
                items.getItemimo().add(item);
            }
            if (items.getItemimo().size() > 0) {
                return items;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private DocumentoType.ItemsType.ItemType.ContenedoresType cargaContenedores(ContainerItem ci) {
        ObjectFactory objFactory = new ObjectFactory();
        try {
            DocumentoType.ItemsType.ItemType.ContenedoresType contenedores = objFactory.createDocumentoTypeItemsTypeItemTypeContenedoresType();
            AttrContainer atc = ci.getContainer("Contenedores");
            Enumeration enm = atc.getItems();
            while (enm.hasMoreElements()) {
                ContainerItem cont = (ContainerItem)enm.nextElement();
                Properties prop = cont.getAttributes();
                DocumentoType.ItemsType.ItemType.ContenedoresType.ContenedorType contenedor = objFactory.createDocumentoTypeItemsTypeItemTypeContenedoresTypeContenedorType();
                if (cont.existContainer("CntIMO")) {
                    contenedor.setCntIMO(this.cargaCntIMO(cont));
                }
                if (prop.containsKey("cnt-so") && !prop.get("cnt-so").equals("")) {
                    contenedor.setCntSo(String.valueOf(prop.get("cnt-so")).trim());
                }
                if (prop.containsKey("digito") && !prop.get("digito").equals("")) {
                    contenedor.setDigito(String.valueOf(prop.get("digito")).trim());
                }
                if (prop.containsKey("nombre-operador") && !prop.get("nombre-operador").equals("")) {
                    contenedor.setNombreOperador(String.valueOf(prop.get("nombre-operador")).trim());
                }
                if (prop.containsKey("numero") && !prop.get("numero").equals("")) {
                    contenedor.setNumero(String.valueOf(prop.get("numero")).trim());
                }
                if (prop.containsKey("peso") && !prop.get("peso").equals("")) {
                    contenedor.setPeso(String.valueOf(prop.get("peso")).trim());
                }
                if (cont.existContainer("Sellos")) {
                    contenedor.setSellos(this.cargaSellos(cont));
                }
                if (prop.containsKey("sigla") && !prop.get("sigla").equals("")) {
                    contenedor.setSigla(String.valueOf(prop.get("sigla")).trim());
                }
                if (prop.containsKey("status") && !prop.get("status").equals("")) {
                    contenedor.setStatus(String.valueOf(prop.get("status")).trim());
                }
                if (prop.containsKey("tipo-cnt") && !prop.get("tipo-cnt").equals("")) {
                    contenedor.setTipoCnt(String.valueOf(prop.get("tipo-cnt")).trim());
                }
                if (prop.containsKey("valor-id-op") && !prop.get("valor-id-op").equals("")) {
                    contenedor.setValorIdOp(String.valueOf(prop.get("valor-id-op")).trim());
                }
                contenedores.getContenedor().add(contenedor);
            }
            if (contenedores.getContenedor().size() > 0) {
                return contenedores;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private DocumentoType.ItemsType.ItemType.ContenedoresType.ContenedorType.CntIMOType cargaCntIMO(ContainerItem contenedor) {
        ObjectFactory objFactory = new ObjectFactory();
        try {
            DocumentoType.ItemsType.ItemType.ContenedoresType.ContenedorType.CntIMOType CntIMO = objFactory.createDocumentoTypeItemsTypeItemTypeContenedoresTypeContenedorTypeCntIMOType();
            AttrContainer atc = contenedor.getContainer("CntIMO");
            Enumeration enm = atc.getItems();
            while (enm.hasMoreElements()) {
                ContainerItem cont = (ContainerItem)enm.nextElement();
                Properties prop = cont.getAttributes();
                DocumentoType.ItemsType.ItemType.ContenedoresType.ContenedorType.CntIMOType.CntimoType cntIMO = objFactory.createDocumentoTypeItemsTypeItemTypeContenedoresTypeContenedorTypeCntIMOTypeCntimoType();
                if (prop.containsKey("clase-imo") && !prop.get("clase-imo").equals("")) {
                    cntIMO.setClaseImo(String.valueOf(prop.get("clase-imo")).trim());
                }
                if (prop.containsKey("numero-imo") && !prop.get("numero-imo").equals("")) {
                    cntIMO.setNumeroImo(String.valueOf(prop.get("numero-imo")).trim());
                }
                CntIMO.getCntimo().add(cntIMO);
            }
            if (CntIMO.getCntimo().size() > 0) {
                return CntIMO;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private DocumentoType.ItemsType.ItemType.ContenedoresType.ContenedorType.SellosType cargaSellos(ContainerItem contenedor) {
        ObjectFactory objFactory = new ObjectFactory();
        try {
            DocumentoType.ItemsType.ItemType.ContenedoresType.ContenedorType.SellosType sellos = objFactory.createDocumentoTypeItemsTypeItemTypeContenedoresTypeContenedorTypeSellosType();
            AttrContainer atc = contenedor.getContainer("Sellos");
            Enumeration enm = atc.getItems();
            while (enm.hasMoreElements()) {
                ContainerItem cont = (ContainerItem)enm.nextElement();
                Properties prop = cont.getAttributes();
                DocumentoType.ItemsType.ItemType.ContenedoresType.ContenedorType.SellosType.SelloType sello = objFactory.createDocumentoTypeItemsTypeItemTypeContenedoresTypeContenedorTypeSellosTypeSelloType();
                if (prop.containsKey("codigo") && !prop.get("codigo").equals("")) {
                    sello.setCodigo(String.valueOf(prop.get("codigo")).trim());
                }
                if (prop.containsKey("emisor") && !prop.get("emisor").equals("")) {
                    sello.setEmisor(String.valueOf(prop.get("emisor")).trim());
                }
                if (prop.containsKey("numero") && !prop.get("numero").equals("")) {
                    sello.setNumero(String.valueOf(prop.get("numero")).trim());
                }
                sellos.getSello().add(sello);
            }
            if (sellos.getSello().size() > 0) {
                return sellos;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private DocumentoType.ItemsType.ItemType.VehiculosType cargaVehiculos(ContainerItem ci) {
        ObjectFactory objFactory = new ObjectFactory();
        try {
            DocumentoType.ItemsType.ItemType.VehiculosType vehiculos = objFactory.createDocumentoTypeItemsTypeItemTypeVehiculosType();
            AttrContainer atc = ci.getContainer("Vehiculos");
            Enumeration enm = atc.getItems();
            while (enm.hasMoreElements()) {
                ContainerItem cont = (ContainerItem)enm.nextElement();
                Properties prop = cont.getAttributes();
                DocumentoType.ItemsType.ItemType.VehiculosType.VehiculoType vehiculo = objFactory.createDocumentoTypeItemsTypeItemTypeVehiculosTypeVehiculoType();
                if (prop.containsKey("chassis") && !prop.get("chassis").equals("")) {
                    vehiculo.setChassis(String.valueOf(prop.get("chassis")).trim());
                }
                if (prop.containsKey("id-cajon") && !prop.get("id-cajon").equals("")) {
                    vehiculo.setIdCajon(String.valueOf(prop.get("id-cajon")).trim());
                }
                if (prop.containsKey("marca") && !prop.get("marca").equals("")) {
                    vehiculo.setMarca(String.valueOf(prop.get("marca")).trim());
                }
                if (prop.containsKey("modelo") && !prop.get("modelo").equals("")) {
                    vehiculo.setModelo(String.valueOf(prop.get("modelo")).trim());
                }
                if (prop.containsKey("observacion") && !prop.get("observacion").equals("")) {
                    vehiculo.setObservacion(String.valueOf(prop.get("observacion")).trim());
                }
                vehiculos.getVehiculo().add(vehiculo);
            }
            if (vehiculos.getVehiculo().size() > 0) {
                return vehiculos;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private DocumentoType.ItemsType.ItemType.EquiposType cargaEquipos(ContainerItem ci) {
        ObjectFactory objFactory = new ObjectFactory();
        try {
            DocumentoType.ItemsType.ItemType.EquiposType equipos = objFactory.createDocumentoTypeItemsTypeItemTypeEquiposType();
            AttrContainer atc = ci.getContainer("Equipos");
            Enumeration enm = atc.getItems();
            while (enm.hasMoreElements()) {
                ContainerItem cont = (ContainerItem)enm.nextElement();
                Properties prop = cont.getAttributes();
                DocumentoType.ItemsType.ItemType.EquiposType.EquipoType equipo = objFactory.createDocumentoTypeItemsTypeItemTypeEquiposTypeEquipoType();
                if (prop.containsKey("identificacion") && !prop.get("identificacion").equals("")) {
                    equipo.setIdentificacion(String.valueOf(prop.get("identificacion")).trim());
                }
                if (prop.containsKey("sigla") && !prop.get("sigla").equals("")) {
                    equipo.setSigla(String.valueOf(prop.get("sigla")).trim());
                }
                if (prop.containsKey("tipo-equipo") && !prop.get("tipo-equipo").equals("")) {
                    equipo.setTipoEquipo(String.valueOf(prop.get("tipo-equipo")).trim());
                }
                equipos.getEquipo().add(equipo);
            }
            if (equipos.getEquipo().size() > 0) {
                return equipos;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private void cargaReferencias(Documento documento, documentWrapper dw) {
        ObjectFactory objFactory = new ObjectFactory();
        try {
            if (dw.existContainer("Referencias")) {
                DocumentoType.ReferenciasType RefTp = objFactory.createDocumentoTypeReferenciasType();
                DocumentoType.ReferenciasType.ReferenciaType refTp = objFactory.createDocumentoTypeReferenciasTypeReferenciaType();
                AttrContainer atc = dw.getContainer("Referencias");
                Enumeration enm = atc.getItems();
                while (enm.hasMoreElements()) {
                    ContainerItem ci = (ContainerItem)enm.nextElement();
                    Properties prop = ci.getAttributes();
                    refTp = objFactory.createDocumentoTypeReferenciasTypeReferenciaType();
                    if (prop.containsKey("tipo-referencia") && !prop.get("tipo-referencia").equals("")) {
                        refTp.setTipoReferencia(String.valueOf(prop.get("tipo-referencia")).trim());
                    }
                    if (prop.containsKey("numero") && !prop.get("numero").equals("")) {
                        refTp.setNumero(String.valueOf(prop.get("numero")).trim());
                    }
                    if (prop.containsKey("fecha") && !prop.get("fecha").equals("")) {
                        refTp.setFecha(String.valueOf(prop.get("fecha")).trim());
                    }
                    if (prop.containsKey("valor-id-emisor") && !prop.get("valor-id-emisor").equals("")) {
                        refTp.setValorIdEmisor(String.valueOf(prop.get("valor-id-emisor")).trim());
                    }
                    if (prop.containsKey("tipo-id-emisor") && !prop.get("tipo-id-emisor").equals("")) {
                        refTp.setTipoIdEmisor(String.valueOf(prop.get("tipo-id-emisor")).trim());
                    }
                    if (prop.containsKey("nac-id-emisor") && !prop.get("nac-id-emisor").equals("")) {
                        refTp.setNacIdEmisor(String.valueOf(prop.get("nac-id-emisor")).trim());
                    }
                    if (prop.containsKey("emisor") && !prop.get("emisor").equals("")) {
                        refTp.setEmisor(String.valueOf(prop.get("emisor")).trim());
                    }
                    if (prop.containsKey("tipo-documento") && !prop.get("tipo-documento").equals("")) {
                        refTp.setTipoDocumento(String.valueOf(prop.get("tipo-documento")).trim());
                    }
                    RefTp.getReferencia().add(refTp);
                }
                documento.setReferencias(RefTp);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void cargaObservaciones(Documento documento, documentWrapper dw) {
        ObjectFactory objFactory = new ObjectFactory();
        try {
            if (dw.existContainer("Observaciones")) {
                DocumentoType.ObservacionesType ObTp = objFactory.createDocumentoTypeObservacionesType();
                AttrContainer atc = dw.getContainer("Observaciones");
                Enumeration enm = atc.getItems();
                while (enm.hasMoreElements()) {
                    ContainerItem ci = (ContainerItem)enm.nextElement();
                    Properties prop = ci.getAttributes();
                    DocumentoType.ObservacionesType.ObservacionType obTp = objFactory.createDocumentoTypeObservacionesTypeObservacionType();
                    if (prop.containsKey("nombre") && !prop.get("nombre").equals("")) {
                        obTp.setNombre(String.valueOf(prop.get("nombre")).trim());
                    }
                    if (prop.containsKey("contenido") && !prop.get("contenido").equals("")) {
                        obTp.setContenido(String.valueOf(prop.get("contenido")).trim());
                    }
                    ObTp.getObservacion().add(obTp);
                }
                documento.setObservaciones(ObTp);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isValid() {
        return this.valid;
    }
}

