/*
 * Decompiled with CFR 0.152.
 */
package sms.validador;

import java.io.File;
import java.util.Vector;
import sms.soap.Documento;
import sms.soap.Start;
import sms.util.Util;
import sms.validador.BLv10;
import sms.validador.BTIv10;
import sms.validador.GAv20;
import sms.validador.GRv10;
import sms.validador.GTIMEv10;
import sms.validador.MFTOAv20;
import sms.validador.MFTOCv10;
import sms.validador.MFTOv10;
import sms.validador.TIFv10;

public class Validador {
    private String path;
    private Documento[] docs = new Documento[0];
    private Documento[] validos = new Documento[0];

    public Validador(String path, Documento[] docs) {
        this.path = path;
        this.docs = docs;
        this.init();
    }

    private void init() {
        Vector<Documento> valid = new Vector<Documento>();
        Vector<Documento> invalid = new Vector<Documento>();
        try {
            int i = 0;
            while (i < this.docs.length) {
                if (this.docs[i] != null) {
                    String tpDoc = this.docs[i].getFileSrc();
                    if (tpDoc.substring(tpDoc.length() - 4, tpDoc.length()).toLowerCase().equals(".xml")) {
                        if (tpDoc.indexOf("-") != -1) {
                            String version = tpDoc = tpDoc.substring(tpDoc.indexOf("-") + 1, tpDoc.length());
                            if (tpDoc.indexOf("-") != -1) {
                                tpDoc = tpDoc.substring(0, tpDoc.indexOf("-"));
                                if ((version = version.substring(version.indexOf("-") + 1, version.length())).indexOf("-") != -1 && this.existeTPDoc(tpDoc, version = version.substring(0, version.indexOf("-")))) {
                                    if (this.isValid(String.valueOf(this.path) + Util.getSEPARADOR() + "mensajes" + Util.getSEPARADOR() + this.docs[i].getFileSrc(), this.docs[i].getFileSrc(), tpDoc, version)) {
                                        valid.add(this.docs[i]);
                                    } else {
                                        invalid.add(this.docs[i]);
                                    }
                                }
                            }
                        }
                    } else {
                        invalid.add(this.docs[i]);
                        Start.pe("\t=> [" + this.docs[i].getFileSrc() + "]: Documento con extension Invalida.-");
                    }
                }
                ++i;
            }
            this.validos = new Documento[valid.size()];
            int j = 0;
            while (j < valid.size()) {
                this.validos[j] = (Documento)valid.get(j);
                ++j;
            }
            if (!invalid.isEmpty()) {
                if (!new File(String.valueOf(Util.getPATH()) + Util.getSEPARADOR() + "xml" + Util.getSEPARADOR() + "invalidos").exists()) {
                    new File(String.valueOf(Util.getPATH()) + Util.getSEPARADOR() + "xml" + Util.getSEPARADOR() + "invalidos").mkdirs();
                }
                int k = 0;
                while (k < invalid.size()) {
                    Documento doc = (Documento)invalid.get(k);
                    Util.newFile(String.valueOf(Util.getPATH()) + Util.getSEPARADOR() + "mensajes" + Util.getSEPARADOR() + doc.getFileSrc(), String.valueOf(Util.getPATH()) + Util.getSEPARADOR() + "xml" + Util.getSEPARADOR() + "invalidos" + Util.getSEPARADOR() + doc.getFileSrc());
                    Util.deleteFile(String.valueOf(Util.getPATH()) + Util.getSEPARADOR() + "mensajes" + Util.getSEPARADOR() + doc.getFileSrc());
                    ++k;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean existeTPDoc(String tpDoc, String version) {
        if (tpDoc.equals("MFTOA") && version.equals("2.0")) {
            return true;
        }
        if (tpDoc.equals("GA") && version.equals("2.0")) {
            return true;
        }
        if (tpDoc.equals("MFTO") && version.equals("1.0")) {
            return true;
        }
        if (tpDoc.equals("BL") && version.equals("1.0")) {
            return true;
        }
        if (tpDoc.equals("MIC") && version.equals("1.0")) {
            return true;
        }
        if (tpDoc.equals("MFTOC") && version.equals("1.0")) {
            return true;
        }
        if (tpDoc.equals("GTIME") && version.equals("1.0")) {
            return true;
        }
        if (tpDoc.equals("GR") && version.equals("1.0")) {
            return true;
        }
        if (tpDoc.equals("BTI") && version.equals("1.0")) {
            return true;
        }
        return tpDoc.equals("TIF") && version.equals("1.0");
    }

    private boolean isValid(String file, String doc, String tpDoc, String version) {
        if (tpDoc.equals("MFTOA") && version.equals("2.0")) {
            return new MFTOAv20(file, doc).isValid();
        }
        if (tpDoc.equals("GA") && version.equals("2.0")) {
            return new GAv20(file, doc).isValid();
        }
        if (tpDoc.equals("MFTO") && version.equals("1.0")) {
            return new MFTOv10(file, doc).isValid();
        }
        if (tpDoc.equals("BL")) {
            return new BLv10(file, doc).isValid();
        }
        if (tpDoc.equals("MIC")) {
            Start.pe("\t<<<Validaci\u00c3\u00b3n no Implementada para Documentos MIC>>>");
        } else {
            if (tpDoc.equals("MFTOC") && version.equals("1.0")) {
                return new MFTOCv10(file, doc).isValid();
            }
            if (tpDoc.equals("GTIME") && version.equals("1.0")) {
                return new GTIMEv10(file, doc).isValid();
            }
            if (tpDoc.equals("GR") && version.equals("1.0")) {
                return new GRv10(file, doc).isValid();
            }
            if (tpDoc.equals("BTI") && version.equals("1.0")) {
                return new BTIv10(file, doc).isValid();
            }
            if (tpDoc.equals("TIF") && version.equals("1.0")) {
                return new TIFv10(file, doc).isValid();
            }
        }
        return false;
    }

    public Documento[] getValidos() {
        return this.validos;
    }
}

